import React, { useRef, useState } from 'react';
import { Form } from '@ant-design/compatible';
import { BaiduMap } from 'react-baidu-map';
import '@ant-design/compatible/assets/index.css';
import {
  Modal,
  Input,
  DatePicker,
  Checkbox,
  Cascader,
  Radio,
  notification,
  InputNumber,
} from 'antd';
import { apiAddrArea } from '../services';
import { weekOptions, weekDefault } from '../data';

const FormItem = Form.Item;
const { TextArea } = Input;
const { RangePicker } = DatePicker;
const StoreModal = props => {
  const {
    visible,
    onCancel,
    form: { getFieldDecorator, getFieldValue, validateFields, resetFields },
    formData = {},
  } = props;

  const location = useRef();
  const [areaAddr, setAreaAddr] = useState([]);

  const weekD = formData.weekDefault ? formData.weekDefault : weekDefault;

  const handleCancel = isSuccess => {
    resetFields();
    onCancel(isSuccess);
  };
  const handleOk = () => {
    // validateFields(async (error, fieldsValue) => {
    //   if (!error) {
    //     const { auditResult } = fieldsValue;
    //     const data = await shopStore({
    //       ...fieldsValue,
    //       refuseCode: auditResult?.[1],
    //       auditResult: auditResult?.[0],
    //       serviceNo: formData?.serviceNo,
    //     });
    //     if (data.businessCode === '0000') {
    //       notification.success({ message: '审核成功' });
    //       handleCancel(true);
    //     }
    //   }
    // });
  };

  // 获取地址省
  (async () => {
    const [res] = await apiAddrArea();
    if (res) {
      const arr = res.map(item => ({
        isLeaf: false,
        loading: false,
        label: item.addrName,
        value: item.addrId,
      }));
      setAreaAddr(arr);
    }
  })();

  // 获取市区街道
  const loadData = async selectedOptions => {
    const targetOption = selectedOptions[selectedOptions.length - 1];
    targetOption.loading = true;
    const res = await apiAddrArea({
      parentId: targetOption.value,
    });
    if (res) {
      const children = res.map(item => ({
        isLeaf: +item.addrLevel === 4,
        loading: false,
        label: item.addrName,
        value: item.addrId,
      }));
      targetOption.loading = false;
      if (children.length > 0) {
        targetOption.children = children;
      } else {
        targetOption.isLeaf = true;
      }
      setAreaAddr([...areaAddr]);
    }
  };

  const layout = {
    labelCol: { span: 6 },
    wrapperCol: { span: 16 },
  };
  return (
    <Modal
      title="门店信息"
      visible={visible}
      width="800px"
      onOk={() => handleOk()}
      onCancel={() => handleCancel()}
    >
      <Form {...layout} name="formData">
        <FormItem label="门店名称">
          {getFieldDecorator('name', {
            rules: [{ required: true, message: '请输入门店名称!' }],
            initialValue: formData.name,
          })(<Input placeholder="请输入门店名称" maxLength={50} />)}
        </FormItem>
        <FormItem label="门店电话">
          {getFieldDecorator('phone', {
            rules: [{ required: true, message: '请输入门店电话!' }],
            initialValue: formData.phone,
          })(<Input placeholder="请输入门店电话" maxLength={20} />)}
        </FormItem>
        <FormItem label="营业时间">
          {getFieldDecorator('time', {
            rules: [{ required: true, message: '请选择营业时间!' }],
            initialValue: formData.phone,
          })(<RangePicker />)}
        </FormItem>
        <FormItem label=" ">
          {getFieldDecorator('week', {
            rules: [{ required: true, message: '请选择营业日!' }],
            initialValue: formData.week,
          })(<Checkbox.Group options={weekOptions} defaultValue={weekD} />)}
        </FormItem>
        <FormItem label="店铺区域">
          {getFieldDecorator('addr', {
            rules: [{ required: true, type: 'array', message: '请选择店铺区域!' }],
            initialValue: formData.addr,
          })(<Cascader options={areaAddr} loadData={e => loadData(e)} changeOnSelect />)}
        </FormItem>
        <FormItem label="详细地址">
          {getFieldDecorator('address', {
            rules: [{ required: true, message: '请输入详细地址!' }],
            initialValue: formData.address,
          })(<Input placeholder="请输入详细地址" maxLength={100} />)}
        </FormItem>
        <FormItem label="经纬度">
          {getFieldDecorator('lnglat', {
            rules: [{ required: true, message: '请选择经纬度!' }],
            initialValue: formData.lnglat,
          })(<Input placeholder="请选择经纬度" readOnly maxLength={100} />)}
        </FormItem>
        <FormItem label="是否启用">
          {getFieldDecorator('enable', {
            rules: [{ required: true, message: '请选择是否启用!' }],
            initialValue: formData.enable,
          })(
            <Radio.Group>
              <Radio value={1}>是</Radio>
              <Radio value={2}>否</Radio>
            </Radio.Group>,
          )}
        </FormItem>
      </Form>
      <BaiduMap id="location" ref={location} style={{ height: 300 }} />
    </Modal>
  );
};

export default Form.create()(StoreModal);
