import UUID from '@/utils/uuid';

export const layout = {
  labelCol: { span: 6 },
  wrapperCol: { span: 16 },
};

/**
 * 文件路径数组转Upload fileList 列表值
 * * */
export const getFileData = (arr = [], urlKey, nameKey) =>
  arr.map(item => {
    let url = item;
    let name = item;
    if (urlKey) {
      url = item[urlKey];
    }
    if (nameKey) {
      name = item[nameKey];
    }
    return {
      url,
      name,
      uid: UUID.createUUID(),
      status: 'done',
    };
  });
