import request from '@/utils/request';
import config from '../../../config/env.config';
import _ from 'lodash';
// 分页查询所有数据
const { querysApi } = config;

export async function query(params) {
  const queryParams = {
    pageSize: params.pageSize || 10,
    pageNo: params.current || 1,
    beginBillDate: params?.dateTimeRange?.[0],
    endBillDate: params?.dateTimeRange?.[1],
    settleBatchNo: params?.settleBatchNo,
    billType: params?.billType,
    status: params?.status,
  };
  const { data } = await request.post('/selfBill/merchant/querySelfBill', {
    prefix: querysApi,
    data: _.omitBy(queryParams, v => !v),
  });
  return {
    data: data?.records || [],
    total: data?.total || 1,
  };
}

// 对账单确认
export async function confirmSelfBill(params) {
  return request.post('/selfBill/merchant/confirmSelfBill', {
    prefix: querysApi,
    data: params,
  });
}

// 对账下载
export async function downloadSelfBillDetail(params) {
  return request.post('/selfBill/merchant/downloadSelfBillDetail', {
    prefix: querysApi,
    data: params,
    responseType: 'arrayBuffer',
  });
}
