import request from '@/utils/request';
import config from '../../../config/env.config';
import moment from 'moment';
import _ from 'lodash';
// 分页查询所有数据
const { querysApi } = config;

export async function query(params) {
  const queryParams = {
    pageSize: params.pageSize || 10,
    pageNo: params.current || 1,
    payBatchNo: params?.payBatchNo,
    payBeginDate: params?.dateTimeRange?.[0],
    payEndDate: params?.dateTimeRange?.[1],
    paidBeginDate: params?.payTimeRange?.[0],
    paidEndDate: params?.payTimeRange?.[1],
    redInvoiceState: params?.redInvoiceState,
    blueInvoiceState: params?.blueInvoiceState,
    payState: params?.payState,
  };
  const { data } = await request.post('/selfPaymentBill/merchant/page', {
    prefix: querysApi,
    data: _.omitBy(queryParams, v => !v),
  });
  return {
    data: data?.records || [],
    total: data.total || 1,
  };
}

export async function qiniuToken() {
  // const data = await request.get('/upload/getToken', {
  //   prefix: config.opapiHost,
  // });
  const data = await request.get('/api/kdsp/common/upload/token', {
    prefix: config.opapiHost,
  });
  return data?.data?.token;
}
// 付款单导出
export async function selfPaymentExport(params) {
  console.log(params?.dateTimeRange?.[0]);
  const queryParams = {
    payBatchNo: params?.payBatchNo,
    payBeginDate: params?.dateTimeRange?.[0]
      ? moment(params?.dateTimeRange?.[0]).format('yyyy-MM-DD')
      : '',
    payEndDate: params?.dateTimeRange?.[1]
      ? moment(params?.dateTimeRange?.[1]).format('yyyy-MM-DD')
      : '',
    paidBeginDate: params?.payTimeRange?.[0]
      ? moment(params?.payTimeRange?.[1]).format('yyyy-MM-DD')
      : '',
    paidEndDate: params?.payTimeRange?.[1]
      ? moment(params?.payTimeRange?.[1]).format('yyyy-MM-DD')
      : '',
    redInvoiceState: params?.redInvoiceState,
    blueInvoiceState: params?.blueInvoiceState,
    payState: params?.payState,
  };
  return request.post('/selfPaymentBill/merchant/export', {
    prefix: querysApi,
    data: _.omitBy(queryParams, v => !v),
    responseType: 'arrayBuffer',
  });
}
// 付款单导出
export async function selfPaymentexportDetail(params) {
  return request.post('/selfPaymentBill/merchant/exportDetail', {
    prefix: querysApi,
    data: params,
    responseType: 'arrayBuffer',
    headers: {
      'Content-Type': 'application/json;charset=UTF-8',
    },
  });
}
//  申请结算单
export async function settlement(params) {
  return request.get(`/selfPaymentBill/merchant/apply/settlement/${params}`, {
    prefix: querysApi,
  });
}

//  上传发票
export async function uploadBill(params) {
  return request.post('/selfPaymentBill/merchant/upload/bill', {
    prefix: querysApi,
    data: params,
  });
}

/**
 * 补录发票
 * yApi: http://yapi.quantgroups.com/project/549/interface/api/69004
 * */
export async function apiUploadSupplementaryBill(params) {
  return request.post('/selfPaymentBill/merchant/supplementary/upload/bill', {
    prefix: querysApi,
    data: params,
  });
}

/**
 * 查看发票
 * yApi: http://yapi.quantgroups.com/project/549/interface/api/35872
 * */
export async function apiMerchantView(id) {
  return request.get(`/selfPaymentBill/merchant/view/${id}`, {
    prefix: querysApi,
  });
}
