import React, { useState, useEffect } from 'react';
import { Modal, Button } from 'antd';
import { apiQueryLastAuditRecord } from '../service';

const InfoAudit = props => {
  const [audit, setAudit] = useState({});

  const getRecord = async () => {
    const res = await apiQueryLastAuditRecord(props.skuInfo.skuId);
    if (res && res.data) {
      console.log('res :>> ', res);
      setAudit(res.data);
    }
  };

  useEffect(() => {
    if (props.visible) {
      getRecord();
    }
  }, [props.visible]);

  return (
    <Modal
      title="商品信息变更审核"
      visible={props.visible}
      footer={[
        <Button key="back" type="primary" onClick={() => props.onEdit()}>
          再次编辑
        </Button>,
        <Button key="close" onClick={() => props.onCancel()}>
          关闭
        </Button>,
      ]}
    >
      <p>审核状态：{audit.statusDesc}</p>
      <p>申请时间：{audit.createdAt}</p>
      <p>审核结果：{audit.rejectReason}</p>
    </Modal>
  );
};

export default InfoAudit;
