import React, { useState, useRef } from 'react';
import { Button } from 'antd';
import ProTable from '@ant-design/pro-table';
// import { searchList, auditInfoApi, orderDetail } from './service';
import { searchList, orderDetail } from './service';
import { column } from './data';
import AuditModal from './components/auditModal';
import DetailTable from './components/detailTable';

export default () => {
  const table = useRef();
  const [visible, setVisible] = useState(false);
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const [auditInfo, setAuditInfo] = useState({});

  const query = async (params, type) => {
    const tempParams = {
      ...params,
      applyTimeStartAt: params.applyTime?.[0],
      applyTimeEndAt: params.applyTime?.[1],
      orderTimeStartAt: params.orderTime?.[0],
      orderTimeEndAt: params.orderTime?.[1],
      auditStatus: 1,
    };

    return searchList(tempParams, type);
  };

  const viewDetail = async ({ serviceNo }) => {
    const data = await orderDetail({ serviceNo });
    setDetailInfo(data || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
  };
  const openAudit = async ({ serviceNo }) => {
    // const data = await auditInfoApi({ serviceNo });
    setAuditInfo({ serviceNo });
    setVisible(true);
  };
  const columns = [
    ...column,
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'action',
      width: 250,
      fixed: 'right',
      render: (_, r) => [
        <Button key="link1" onClick={() => openAudit(r)} className="mr10" type="primary">
          审核
        </Button>,
        <Button key="link" onClick={() => viewDetail(r)} type="primary">
          订单详情
        </Button>,
      ],
    },
  ];
  return (
    <div>
      <ProTable
        columns={columns}
        request={params => query(params, 1)}
        rowKey="serviceNo"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%', y: 400 }}
        search={{
          collapsed: false,
          collapseRender: () => null,
        }}
        toolBarRender={false}
      />
      <AuditModal visible={visible} onCancel={closeModal} formData={auditInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
    </div>
  );
};
