import { ConsoleSqlOutlined } from '@ant-design/icons';

export const cleanArray = actual => {
  const newArray = [];
  // eslint-disable-next-line no-plusplus
  for (let i = 0; i < actual.length; i++) {
    if (actual[i]) {
      newArray.push(actual[i]);
    }
  }
  return newArray;
};

const createInitProduct = (skuItem, isCreate) => {
  if (isCreate && Object.keys(skuItem).length > 5) {
    return skuItem;
  }
  return {
    // firstSpecValue: '',
    // secondSpecValue: '',
    weight: null,
    productStockWarning: null,
    marketPrice: null,
    supplyPrice: null,
    stock: null,
    thirdSkuNo: null,
    skuLink: null,
  };
};

const initData = {
  // firstSpecValue: '',
  // secondSpecValue: '',
  weight: null,
  productStockWarning: null,
  marketPrice: null,
  supplyPrice: null,
  stock: null,
  thirdSkuNo: null,
  skuLink: null,
};

const createSecondProduct = (secondSpecList, initItem, secondSpec, dataSource, callback) => {
  secondSpecList.forEach(secondItem => {
    console.log('============>', Object.keys(secondItem));

    const specSecond =
      Object.keys(secondItem).length < 2
        ? {
            firstSpecId: initItem.firstSpecId,
            firstSpecValue: initItem.firstSpecValue,
            ...initData,
          }
        : Object.assign({}, initItem); // 继承fist参数

    if (callback) {
      callback(specSecond);
    }
    specSecond.secondSpecId = secondSpec;
    specSecond.secondSpecValue = secondItem.secondSpecValue;
    dataSource.push(specSecond);
  });
};

export const createProductData = ({ firstValues, secondValues, firstSpecId, secondSpecId }) => {
  console.log(firstValues, secondValues);
  const countRowSpan = {};
  const dataSource = [];
  if (firstValues.length) {
    firstValues.forEach((fisrtItem, index) => {
      const specFirst = createInitProduct(fisrtItem, true);
      specFirst.firstSpecId = firstSpecId;
      specFirst.firstSpecValue = fisrtItem.firstSpecValue;
      if (secondValues.length) {
        createSecondProduct(secondValues, specFirst, secondSpecId, dataSource, specSecond => {
          if (!countRowSpan[specFirst.firstSpecValue]) {
            countRowSpan[specFirst.firstSpecValue] = true;
            specSecond.rowSpanCount = secondValues.length;
          }
        });
        return;
      }
      dataSource.push(specFirst);
    });
  } else if (secondValues.length) {
    // const childData = createInitProduct();
    createSecondProduct(secondValues, initData, secondSpecId, dataSource);
  } else {
    const specFirst = createInitProduct();
    dataSource.push(specFirst);
  }
  return dataSource;
};
