import { ConsoleSqlOutlined, MinusCircleOutlined, PlusOutlined } from '@ant-design/icons';
import { Button, Form, Input, Select, Space, Modal, notification } from 'antd';
import React, { useState, forwardRef, useImperativeHandle, useEffect } from 'react';
import { useParams } from 'react-router-dom';
import { formItemLayout } from '../config';
import EditFormTable from './EditFormTable';
import { createProductData } from '../utils';
import { ServiceContext } from '../context';

const { Option } = Select;

interface SpecItem {
  specId: number;
  specName: string;
}
interface PropsType {
  editData: any;
  specList: Array<SpecItem>;
}

const validatorSpecValue = (value, list, index, specName) => {
  const checkList = list.filter((item, ind) => {
    if (ind === index) {
      return false;
    }
    return item[specName] === value;
  });
  return checkList.length;
};

const isRepeatProduct = (list, message) => {
  const isRepeat = [...new Set(list)].length !== list.length;
  if (isRepeat) {
    notification.warning({ message });
  }
  return isRepeat;
};

const SpecificationTemplate = (props, _) => {
  const { specList, label, name, selectName, specName, form, specDataList } = props;

  console.log('==============>specDataList', specDataList);
  const handleChange = (val, option) => {
    const optionSpecName = option ? option.specName : null;
    form.setFieldsValue({ [selectName]: optionSpecName });
  };

  const bundlePlusAddSpecEvent = (addCallback: () => void) => {
    const specId = form.getFieldValue(name);
    if (!specId) {
      Modal.warning({
        maskClosable: true,
        title: `请先选择${label}！`,
      });
      return;
    }
    console.log(specId);
    addCallback();
  };

  return (
    <>
      <Form.Item name={name} label={label}>
        <Select
          allowClear
          options={specList}
          style={{ width: 200 }}
          fieldNames={{ label: 'specName', value: 'specId' }}
          placeholder={`请选择${label}`}
          showSearch
          filterOption={(input, option) =>
            option.specName.toLowerCase().indexOf(input.toLowerCase()) >= 0
          }
          onChange={handleChange}
        />
      </Form.Item>
      <Form.Item name={selectName} hidden></Form.Item>
      <Form.List name={specName}>
        {(fields, { add, remove }) => (
          <>
            {/* {fields.map((field, index) => (
            <Space key={field.key} align="baseline">
              <Form.Item style={{ marginLeft: 10 }} name={[index]}
                rules={[{ required: true, message: '请输入规格名称' }]}
              >
                <Input placeholder="请输入规格名称" />
              </Form.Item>
              <MinusCircleOutlined onClick={() => remove(field.name)} />
            </Space>
          ))} */}
            {fields.map((field, index) => (
              <Form.Item key={field.key} noStyle shouldUpdate={(prevValues, curValues) => false}>
                {() => (
                  <Space key={field.key} align="baseline">
                    <Form.Item
                      style={{ marginLeft: 10 }}
                      name={[field.name, specName]}
                      rules={[
                        { required: true, message: '请输入规格名称' },
                        {
                          message: '规格名不能重复！',
                          validator(rule, value, callback) {
                            const checkList = form.getFieldValue(specName);
                            const check = validatorSpecValue(value, checkList, index, specName);
                            return check ? callback('规格名不能重复！') : callback();
                          },
                        },
                      ]}
                    >
                      <Input
                        disabled={specDataList[index] && specDataList[index].id}
                        placeholder="请输入规格名称"
                      />
                    </Form.Item>
                    {!(specDataList[index] && specDataList[index].id) && (
                      <MinusCircleOutlined onClick={() => remove(field.name)} />
                    )}
                  </Space>
                )}
              </Form.Item>
            ))}
            {fields.length < 3 && (
              <Form.Item noStyle>
                <Button
                  style={{ marginLeft: 10, marginBottom: 24 }}
                  type="dashed"
                  onClick={() => bundlePlusAddSpecEvent(add)}
                  icon={<PlusOutlined />}
                />
              </Form.Item>
            )}
          </>
        )}
      </Form.List>
    </>
  );
};

const originItems = {
  firstSpecValue: [],
  secondSpecValue: [],
  dataSource: [],
  firstDuplicate: [],
  secondDuplicate: [],
};

const filterItem = skuItem => {
  const { imageList, serviceItem, ...argsItem } = skuItem;
  argsItem.disabled = true;
  return argsItem;
};

const filterSpecData = skuList =>
  skuList.reduce((orgin, skuItem) => {
    // console.log(item);
    const item = filterItem(skuItem);
    const { firstSpecValue, secondSpecValue } = item;

    if (firstSpecValue && !orgin.firstDuplicate.includes(firstSpecValue)) {
      orgin.firstSpecValue.push(item);
      orgin.firstDuplicate.push(firstSpecValue);
    }
    if (secondSpecValue && !orgin.secondDuplicate.includes(secondSpecValue)) {
      orgin.secondSpecValue.push(item);
      orgin.secondDuplicate.push(secondSpecValue);
    }
    // orgin.dataSource.push({
    //   id: item.id,
    //   firstSpec: item.firstSpec,
    //   firstSpecId: item.firstSpecId,
    //   firstSpecValue: item.firstSpecValue,

    //   secondSpec: item.secondSpec,
    //   secondSpecId: item.secondSpecId,
    //   secondSpecValue: item.secondSpecValue,

    //   commissionRate: item.commissionRate,
    //   supplyPrice: item.supplyPrice, // 供货价
    //   marketPrice: item.marketPrice,
    //   salePrice: item.salePrice,
    //   stock: item.stock,
    //   productStockWarning: item.productStockWarning,
    // });

    return orgin;
  }, originItems);

const createTableData = () => {};
const FormPriceOrStock = forwardRef((props: PropsType, ref) => {
  const { specList, editData } = props;
  console.log('============>000000000000', props);
  const [form] = Form.useForm();
  const [specInitValue, setSpecInitValue] = useState({
    firstSpec: '',
    firstSpecId: null,
    firstSpecValue: [],
    secondSpec: '',
    secondSpecId: null,
    secondSpecValue: [],
  });

  const [tableData, setTableData] = useState([]);

  const onFinish = (values: any) => {
    console.log(values);
    // const values = form.getFieldsValue();
    // const { firstValues = [], secondValues = [], firstSpecId, secondSpecId } = values;
    // if ([fisrtIsRepeat, secondIsRepeat].includes(true)) {
    //   setTableData([]);
    //   return;
    // }

    const cleanValues = {
      firstValues: values.firstSpecValue,
      secondValues: values.secondSpecValue,
      firstSpecId: values.firstSpecId,
      secondSpecId: values.secondSpecId,
    };

    const newData = createProductData(cleanValues);
    // console.log('=============>生成商品数据', newData);
    setTableData(newData);
    // // const columnsData = createProductColumns(cleanValues, newData);
    // form.resetFields('tableArray', []);

    // setColumns(columnsData);
    // setProductData(newData);
    // console.log(newData);
    // console.log(columnsData);

    if (!values.firstSpecId && !values.firstSpecId) {
      // 如果两个都没有选择默认生成一条数据
      // Modal.warning({
      //   maskClosable: true,
      //   title: '请先选择规格分类！',
      // });
    }
  };

  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
  }));
  const { id } = useParams<any>();
  useEffect(() => {
    if (+id !== 0) {
      if (!Object.keys(editData).length) return;
      const { skuList } = editData;
      const [oneItem] = skuList;
      // 根据接口过滤数据
      const { firstSpecValue, secondSpecValue, dataSource } = filterSpecData(skuList);
      const specData = {
        firstSpec: oneItem.firstSpec,
        firstSpecId: oneItem.firstSpecId,
        firstSpecValue,
        secondSpec: oneItem.secondSpec,
        secondSpecId: oneItem.secondSpecId,
        secondSpecValue,
      };
      form.setFieldsValue(specData); // 设置规格数据
      setSpecInitValue(specData); // 缓存规格数据
      setTableData([...dataSource]);
    }
  }, [id, editData]);

  return (
    // {...formItemLayout}

    <Form
      form={form}
      name="dynamic_form_nest_item"
      onFinish={onFinish}
      autoComplete="off"
      initialValues={specInitValue}
    >
      <SpecificationTemplate
        form={form}
        label="一级规格"
        name="firstSpecId"
        selectName="firstSpec"
        specName="firstSpecValue"
        specList={specList}
        specDataList={specInitValue.firstSpecValue}
      />
      <SpecificationTemplate
        form={form}
        label="二级规格"
        name="secondSpecId"
        selectName="secondSpec"
        specName="secondSpecValue"
        specList={specList}
        specDataList={specInitValue.secondSpecValue}
      />

      <Form.Item>
        <Button type="primary" htmlType="submit">
          生成商品信息
        </Button>
      </Form.Item>

      <EditFormTable initData={tableData} />
    </Form>
  );
});

export default FormPriceOrStock;
