import { InputNumber, InputRef } from 'antd';
import { Button, Form, Input, Popconfirm, Table } from 'antd';
import type { FormInstance } from 'antd/es/form';
import React, { useContext, useEffect, useRef, useState } from 'react';

const EditableContext = React.createContext<FormInstance<any> | null>(null);

interface PropType {
  initData: any[];
};
interface Item {
  key: string;
  name: string;
  age: string;
  address: string;
}
interface EditableCellProps {
  rowIndex: number;
  title: React.ReactNode;
  editable: boolean;
  children: React.ReactNode;
  dataIndex: keyof Item;
  record: Item;
  handleSave: (record: Item) => void;
}
interface EditableRowProps {
  index: number;
}
interface DataType {
  rowSpanCount?: number;
  supplyPrice: number;
  commissionRate: number;
  marketPrice: number;
  salePrice: number;
  stock: number;
  productStockWarning: number;
}
type EditableTableProps = Parameters<typeof Table>[0];
type ColumnTypes = Exclude<EditableTableProps['columns'], undefined>;

const EditableRow: React.FC<EditableRowProps> = ({ index, ...props }) => {
  // console.log('==========> index', props);
  // const [form] = Form.useForm();
  // console.log('==========>props', props)
  return (
    // <Form form={form} component={false}>
    //   <EditableContext.Provider value={form}>
        <tr {...props} />
      // </EditableContext.Provider>
    // </Form>
  );
};


const EditableCell: React.FC<EditableCellProps> = (props) => {
  const {
    rowIndex,
    title,
    editable,
    children,
    dataIndex,
    record,
    handleSave,
    ...restProps
  } = props;
  const form = useContext(EditableContext)!;
  const save = async () => {
    try {
      const tableList = form.getFieldValue('tableList');
      handleSave(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  let childNode = children;

  if (editable) {
    childNode = <Form.Item
      style={{ margin: 0 }}
      name={['tableList', rowIndex, dataIndex]}
      // initialValue={record[dataIndex]}
      rules={[{ required: true, message: `${title} is required.` }]}>
      <InputNumber onBlur={save} />
    </Form.Item>
  }
  return <td {...restProps}>{childNode}</td>;
};





const EditFormTable = (props: PropType) => {

  const { initData } = props;
  // console.log(initData);
  const [dataSource, setDataSource] = useState<DataType[]>([]);
  const [form] = Form.useForm();

  useEffect(() => {
    console.log('==============>坚听initData', initData);
    

    form.setFieldsValue({
      tableList: initData,
    });
    setDataSource(initData);
  }, [initData])


  const defaultColumns: (ColumnTypes[number] & { editable?: boolean; dataIndex: string })[] = [
    {
      title: '一级规格',
      dataIndex: 'firstSpecValue',
    },
    {
      title: '二级规格',
      dataIndex: 'secondSpecValue',
    },
    {
      title: '供货价',
      dataIndex: 'supplyPrice',
      editable: true,
    },
    {
      title: '佣金费率',
      dataIndex: 'commissionRate',
      editable: true,
    },
    {
      title: '市场价',
      dataIndex: 'marketPrice',
      editable: true,
    },
    {
      title: '销售价',
      dataIndex: 'salePrice',
      editable: true,
    },
    {
      title: '库存',
      dataIndex: 'stock',
      editable: true,
    },
    {
      title: '库存预警阈值',
      dataIndex: 'productStockWarning',
      editable: true,
    },
  ];

  const handleAdd = async () => {
    try {
      const { tableList } = await form.validateFields();
      console.log(tableList);
    } catch (errInfo) {
      console.log('Save failed:', errInfo);
    }
  };

  const handleSave = (row: DataType[]) => {
    // console.log('============>row', row);
    // const newData = [...dataSource];
    // const index = newData.findIndex(item => row.key === item.key);
    // const item = newData[index];
    // newData.splice(index, 1, {
    //   ...item,
    //   ...row,
    // });
    setDataSource([...row]);
  };
  // 根据这里做判断渲染表格
  const columns = defaultColumns.map((col, colIndex) => {
    // if (!col.editable) {
    //   return col;
    // }
    

    return {
      ...col,
      onCell: (record: DataType, rowIndex: number) => {
        let rowSpan = null;
        if (col.dataIndex === 'firstSpecValue') {
          // console.log(record, rowSpan);
          rowSpan = record.rowSpanCount ? record.rowSpanCount : 0;
        }

        return ({
          rowSpan,
          record,
          rowIndex,
          editable: col.editable,
          dataIndex: col.dataIndex,
          title: col.title,
          handleSave,
        });
      }
    };
  });
  
  return (
    <div>
      <Button onClick={handleAdd} type="primary" style={{ marginBottom: 16 }}>
        Add a row
      </Button>
      <Form form={form} scrollToFirstError component={false}>
        <EditableContext.Provider value={form}>
          <Table
            pagination={false}
            size="small"
            components={{
              body: {
                row: EditableRow,
                cell: EditableCell,
              },
            }}
            bordered
            dataSource={dataSource}
            rowKey={(row, rowInd) => rowInd}
            columns={columns as ColumnTypes}
          />
        </EditableContext.Provider>
      </Form>
    </div>
  );
};

export default EditFormTable;