import React from 'react';
import { Button, Badge } from 'antd';
import styles from './style.less';

export const productType = [
  {
    value: 1,
    title: '自营',
  },
  {
    value: 2,
    title: '京东开普勒',
  },
  {
    value: 3,
    title: '京东联盟',
  },
  {
    value: 4,
    title: '众联',
  },
  {
    value: 5,
    title: '企业购',
  },
  {
    value: 6,
    title: '企业购直连',
  },
];

export function column() {
  return [
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 125,
      align: 'center',
      render: (_, row) => {
        if (row.type !== 1) {
          return (
            <Badge
              count={
                <div
                  style={{
                    color: '#fff',
                    borderRadius: '3px',
                    background: '#f5222d',
                    padding: '2px',
                    fontSize: '10px',
                    opacity: 0.7,
                  }}
                >
                  虚拟
                </div>
              }
            >
              <div
                style={{
                  background: '#fbfbfb',
                  borderRadius: '3px',
                  padding: '2px',
                }}
              >
                {row.skuId}
              </div>
            </Badge>
          );
        }
        return (
          <div
            style={{
              background: '#fbfbfb',
              borderRadius: '3px',
              padding: '2px',
            }}
          >
            {row.skuId}
          </div>
        );
      },
    },
    {
      title: 'SKU商品名称',
      width: 135,
      align: 'center',
      dataIndex: 'skuName',
    },

    {
      title: '供应商价格',
      dataIndex: 'marketPrice',
      width: 150,
      align: 'center',
      sorter: (a, b) => a.supplyPrice - b.supplyPrice,
      render: (_, row) => (
        <div className={styles.price}>
          <p>供货价：{(row.supplyPrice || 0).toFixed(2)}</p>
          <p>市场价：{(row.marketPrice || 0).toFixed(2)}</p>
        </div>
      ),
    },
    {
      title: '库存',
      width: 120,
      dataIndex: 'stock',
      align: 'center',
      sorter: (a, b) => a.stock - b.stock,
      render: (_, row) => {
        // const stockView =
        //   row.state !== 4 ? (
        //     <a onClick={() => this.openModal(row, 'productStock')}>{row.productStock}</a>
        //   ) : (
        //     <span>{row.productStock}</span>
        //   );
        const stockView = row.productStock;
        return (
          <>
            <p>当前库存：{stockView}</p>
            <p>可售库存：{_}</p>
            {row.type === 1 && row.productStockWarning > 0 && (
              <p>预警值：{row.productStockWarning}</p>
            )}
          </>
        );
      },
    },
    {
      title: '不支持配送区域',
      dataIndex: 'areaTemplateName',
      key: 'areaTemplateName',
      width: 200,
      align: 'center',
    },
    {
      title: '审核状态',
      dataIndex: 'stateDesc',
      width: 200,
      align: 'center',
      render: (_, row) => (
        <div>
          <p>{row.state >= 5 ? '审核通过' : _}</p>
          <p>{row.updateState || '_ _'}</p>
        </div>
      ),
    },
    {
      title: '操作',
      dataIndex: 'action',
      width: 120,
      align: 'center',
      render: (_, row) => (
        <div className={styles.actionBtn}>
          {(row.state === 4 || (row.state === 5 && row.updateState !== 1)) && (
            <Button
              key="edit"
              type="primary"
              size="small"
              className={styles.button}
              onClick={() => this.onUpdateInfo(row)}
            >
              修改
            </Button>
          )}
          <Button
            key="viewP"
            type="primary"
            size="small"
            className={styles.button}
            onClick={() => this.audit(row.skuId)}
          >
            预览
          </Button>
          <Button
            key="log"
            size="small"
            type="primary"
            className={styles.button}
            onClick={() => this.viewLog(row)}
          >
            查看日志
          </Button>
        </div>
      ),
    },
  ];
}
export const disSelectStatus = [2, 5];
export const stateList = [
  { value: 3, label: '待审核' },
  { value: 4, label: '驳回' },
  { value: 5, label: '审核通过' },
];

// AUDITING(3, "待审核"),REJECTED(4, "驳回"),WAIT_SELL(5, "未上架"),ON_SELL(6, "已上架"),OFF_SHELVES(7, "已下架")）
export const productTypeList = [
  { value: 1, label: '实体商品' },
  { value: 2, label: '虚拟充值' },
  { value: 3, label: '虚拟卡券', disabled: true },
];

export const JDSHOPID = [3, 5, 6];
