import React, { useState, useEffect, useContext, forwardRef, useImperativeHandle } from 'react';
import { Form } from 'antd';
import { ServiceContext } from '../context';
import UploadImage from './UploadImage';
import { formItemLayout } from '../config';

const FormRuleVPictures = forwardRef((props, ref) => {
  const { editData, specKeyItem } = props;
  const [form] = Form.useForm();
  const [imageList, setImageList] = useState({});
  const [commonImageList, setCommonImageList] = useState([]);
  const [detailImageList, setDetailImageList] = useState([]);
  const customer = useContext(ServiceContext);
  useEffect(() => {
    if (customer.isEdit) {
      console.log('==============>图片', editData)
      if (!Object.keys(editData).length) return;
      setCommonImageList(editData.commonImageList); // 编辑状态下设置公共图
      setDetailImageList(editData.detailImageList); // 编辑状态下设置详情图
      const commImg = editData.skuList.reduce((orgin, item) => {
        const keyString = `${item.firstSpecValue}`; // _${item.firstSpecId}
        if (!Object.keys(orgin).includes(keyString)) {
          orgin[keyString] = item.imageList;
        }
        return orgin;
      }, {});

      setImageList(commImg);
      form.setFieldsValue({
        imageList: commImg,
        commonImageList: editData.commonImageList,
        detailImageList: editData.detailImageList,
      });
    }
  }, [customer.isEdit, editData]);

  useEffect(() => {
    const newImageList = specKeyItem.reduce((origin, item) => {
      const showItem = imageList[item] || [];
      origin[item] = showItem;
      return origin;
    }, {});
    setImageList(newImageList);
  }, [specKeyItem])


  const onCheck = async () => {
    try {
      const values = await form.validateFields();
      console.log(values)
      return values;
    } catch (errorInfo) {
      return null;
    }
  };

  useImperativeHandle(ref, () => ({
    onCheck,
    reset: form.resetFields,
  }));

  const onFinish = values => {
    console.log('Received values of form: ', values);
  };
  const onPictureSuccessEvent = (imgList, key) => {
    setImageList({
      ...imageList,
      [key]: imgList,
    });
  }
  return (
    <>
      <Form
        {...formItemLayout}
        form={form}
        name="register"
        onFinish={onFinish}
        initialValues={{
          imageList,
          commonImageList,
          detailImageList,
        }}
        scrollToFirstError
      >
        <Form.Item
          label="封面图片"
          name="commonImageList"
          extra={`建议尺寸: ##宽##高 (${commonImageList.length} / 1) `}
          rules={[
            { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
          ]}
        >
          <UploadImage
            name="commonImageList"
            limit={1}
            pictures={commonImageList}
            setPictureList={setCommonImageList}
          />
        </Form.Item>

        {Object.keys(imageList).map(key =>
          <Form.Item
            key={key}
            label={`商品图片(${key})`}
            name={['imageList', key]}
            extra={`建议尺寸: ##宽##高 (${imageList[key].length} / 11) `}
            rules={[
              { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
            ]}
          >
            <UploadImage
              name={key}
              limit={11}
              pictures={imageList[key]}
              setPictureList={list => onPictureSuccessEvent(list, key)}
            />
          </Form.Item>)}
        <Form.Item
          label="商品详情图"
          name="detailImageList"
          extra={`最多上传30张，${detailImageList.length} / 30`}
          rules={[
            { required: true, type: 'array', message: '请输入温馨提示', validateTrigger: 'submit' },
          ]}
        >
          <UploadImage
            name="detailImageList"
            limit={4}
            pictures={detailImageList}
            setPictureList={setDetailImageList}
          />
        </Form.Item>
      </Form>
    </>
  );
});

export default FormRuleVPictures;
