import RoleType, { isPlatForm } from './role.config';
const isProduction = process.env.NODE_ENV === 'production';
const isPre = process.env.PRE_ENV === 'pre';
const environment = 'sc';

const envAPi = {
  api: `https://security-${environment}.liangkebang.net`, //'https://security-xyqb.liangkebang.net',
  kdspOpApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  kdspApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  goodsApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  querysApi: `https://sc-merchant-api-${environment}.liangkebang.net/admin/merchant/sc-settlement`,
  prologueDomain: `https://mall-${environment}.liangkebang.net`,
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  opapiHost: `https://gw.yxmie.com`,
  wsApi: `wss://push-${environment}.liangkebang.net`,
  msgApi: `https://msgapi-${environment}.liangkebang.net`,
  roleApi: isPlatForm
    ? `https://sc-op-api-${environment}.liangkebang.net`
    : `https://sc-merchant-api-${environment}.liangkebang.net`,
};

const prodApi = {
  api: `https://security-${environment}.liangkebang.net`, //'https://security-xyqb.liangkebang.net',
  kdspOpApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  kdspApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  goodsApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  querysApi: `https://sc-merchant-api-${environment}.liangkebang.net/admin/merchant/sc-settlement`,
  prologueDomain: `https://mall-${environment}.liangkebang.net`,
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  opapiHost: `https://gw.yxmie.com`,
  wsApi: `wss://push-${environment}.liangkebang.net`,
  msgApi: `https://msgapi-${environment}.liangkebang.net`,
  roleApi: isPlatForm
    ? `https://sc-op-api-${environment}.liangkebang.net`
    : `https://sc-merchant-api-${environment}.liangkebang.net`,
};

const preProdApi = {
  api: `https://security-${environment}.liangkebang.net`, //'https://security-xyqb.liangkebang.net',
  kdspOpApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  kdspApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  goodsApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  querysApi: `https://sc-merchant-api-${environment}.liangkebang.net/admin/merchant/sc-settlement`,
  prologueDomain: `https://mall-${environment}.liangkebang.net`,
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  opapiHost: `https://gw.yxmie.com`,
  wsApi: `wss://push-${environment}.liangkebang.net`,
  msgApi: `https://msgapi-${environment}.liangkebang.net`,
  roleApi: isPlatForm
    ? `https://sc-op-api-${environment}.liangkebang.net`
    : `https://sc-merchant-api-${environment}.liangkebang.net`,
};

let json = envAPi;
if (isPre) {
  json = preProdApi;
} else if (isProduction) {
  json = prodApi;
}
const exportApi = Object.assign({}, RoleType, json);
// module.exports = exportApi;

// let exportApi;
// isProduction ? (exportApi = prodApi) : (exportApi = envAPi);

export default exportApi;
