import React, { useEffect, useRef, useState } from 'react';
import { Select, Space, Divider, Input, Button } from 'antd';
import { PlusOutlined } from '@ant-design/icons';

const CustomSelect = props => {
  const [name, setName] = useState('');
  const [items, setItems] = useState([]);

  const inputRef = useRef(null);

  const onNameChange = e => {
    setName(e.target.value);
  };

  const addItem = e => {
    e.preventDefault();
    const v = name.trim();
    if (v) {
      setItems([...items, { name: v }]);
      setName('');
      setTimeout(() => {
        // eslint-disable-next-line no-unused-expressions
        inputRef.current?.focus();
      }, 0);
    }
  };

  const onChange = e => {
    props.onChange(e);
  };

  useEffect(() => {
    setItems(props.options);
  }, [props.options]);

  return (
    <Select
      mode={props.mode}
      maxTagTextLength={8}
      allowClear
      value={props.value}
      onChange={onChange}
      dropdownRender={menu => (
        <>
          {menu}
          {props.isCustom && (
            <>
              <Divider style={{ margin: '8px 0' }} />
              <Space style={{ padding: '0 8px 4px' }}>
                <Input
                  placeholder="请输入自定义属性"
                  ref={inputRef}
                  value={name}
                  onChange={onNameChange}
                />
                <Button type="text" icon={<PlusOutlined />} onClick={addItem} />
              </Space>
            </>
          )}
        </>
      )}
      options={items.map(item => ({ label: item.name, value: JSON.stringify(item) }))}
    ></Select>
  );
};

export default CustomSelect;
