import { Tag } from 'antd';
import React from 'react';

export const appealType = {
  1: '已申诉',
  0: '未申诉',
};
export const columnSticData = [
  {
    title: '订单ID',
    dataIndex: 'orderNo',
    hideInSearch: true,
    width: 300,
    // eslint-disable-next-line no-confusing-arrow
    render: (orderNo, r) =>
      r.timeout || r.reminderFlag ? (
        <Tag color={r.timeout ? 'red' : 'green'}>{orderNo}</Tag>
      ) : (
        orderNo
      ),
  },
  {
    title: '售后单ID',
    dataIndex: 'serviceNo',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '收货人姓名',
    dataIndex: 'receiverName',
    width: 200,
  },
  {
    title: '收货人手机号',
    dataIndex: 'receiverPhone',
    width: 200,
  },
  {
    title: '收货人地址',
    dataIndex: 'receiveAddress',
    width: 200,
    hideInSearch: true,
  },
  {
    title: '售后类型',
    dataIndex: 'serviceType',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      1: '退款不退货',
      2: '退货退款',
    },
  },
  {
    title: '售后原因',
    dataIndex: 'serviceReason',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '售后发生时间',
    dataIndex: 'serviceTime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '超时时间',
    dataIndex: 'overTime',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '是否催办',
    dataIndex: 'reminderFlag',
    hideInSearch: true,
    width: 120,
    valueEnum: {
      true: '是',
      false: '否',
    },
  },
  {
    title: '是否同意售后',
    dataIndex: 'isAgree',
    hideInSearch: true,
    width: 120,
  },
  {
    title: '拒绝原因',
    dataIndex: 'refuseReason',
    hideInSearch: true,
    width: 200,
  },
];
export const columnPassAudit = [
  ...columnSticData,
  {
    title: '商家退货地址',
    dataIndex: 'merchantAddress',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '退回物流',
    dataIndex: 'expressCompanyName',
    hideInSearch: true,
    width: 150,
  },
  {
    title: '退回物流单号',
    dataIndex: 'deliveryNo',
    hideInSearch: true,
    width: 200,
  },
  {
    title: '售后状态',
    dataIndex: 'serviceStatus',
    hideInSearch: true,
    width: 120,
  },
];
