import React, { useState } from 'react';
import { Input, Tag } from 'antd';
import { PlusOutlined } from '@ant-design/icons';
import styles from '../../style.less';

const InsertTag = options => {
  const [inputVisible, setInputVisible] = useState(false);
  const [inputValue, setInputValue] = useState('');

  const showInput = () => {
    setInputVisible(true);
  };
  const handleInputChange = e => {
    setInputValue(e.target.value);
  };
  const handleInputConfirm = () => {
    setInputVisible(false);
    setInputValue('');
  };

  return (
    <span>
      {inputVisible && (
        <Input
          type="text"
          size="small"
          className={styles['groupBox-body--tag-input']}
          value={inputValue}
          onChange={handleInputChange}
          onBlur={handleInputConfirm}
          onPressEnter={handleInputConfirm}
        />
      )}
      {!inputVisible && (
        <Tag
          className={[styles['groupBox-body--tag'], styles['groupBox-body--new']]}
          onClick={showInput}
        >
          <PlusOutlined /> 添加
        </Tag>
      )}
    </span>
  );
};

export default InsertTag;
