import request from '@/utils/request';
import config from '@/../config/env.config';

// import qs from 'qs';

const { kdspApi, goodsApi } = config;

/**
 * 获取企业客户列表
 * http://yapi.quantgroups.com/project/389/interface/api/65324
 */
export async function apiEnterpriseList(data) {
  return request.post('/api/consoles/enterprise/pageList', {
    data,
    prefix: goodsApi,
  });
}
/**
 * 获取企业客户详细
 * http://yapi.quantgroups.com/project/389/interface/api/65339
 */
export async function apiEnterpriseInfo(id) {
  return request.get(`/api/consoles/enterprise/info?id=${id}`, {
    prefix: goodsApi,
  });
}
/**
 * 添加企业客户
 * http://yapi.quantgroups.com/project/389/interface/api/65329
 */
export async function apiNewEnterprise(data) {
  return request.post('/api/consoles/enterprise/save', {
    data,
    prefix: goodsApi,
  });
}
/**
 * 编辑企业客户
 * http://yapi.quantgroups.com/project/389/interface/api/65334
 */
export async function apiEditEnterprise(data) {
  return request.post('/api/consoles/enterprise/update', {
    data,
    prefix: goodsApi,
  });
}

/**
 * 查询自提点列表
 * http://yapi.quantgroups.com/project/389/interface/api/65494
 */
export async function apiEnterprisePickSelf(data) {
  return request.post('/api/consoles/selfPickUpLocation/list', {
    data,
    prefix: goodsApi,
  });
}
