import React, { forwardRef } from 'react';
import { Modal, Form, Select } from 'antd';

const SwitchGroupModal = forwardRef(options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
  };

  const radioOptions = [{ label: '是', value: 1 }, { label: '否', value: 0 }];
  const initialValues = Object.assign({}, options.initialValues);

  return (
    <Modal
      visible={options.visible}
      title="更改分组"
      onOk={handleOk}
      maskClosable={false}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label="分组"
          name="storageRackId"
          rules={[{ required: true, message: '请选择!' }]}
        >
          <Select options={radioOptions} />
        </Form.Item>
      </Form>
    </Modal>
  );
});

export default SwitchGroupModal;
