import React, { forwardRef, useState } from 'react';
import { Modal, Form } from 'antd';

const StockModal = forwardRef(options => {
  const [form] = Form.useForm();
  const handleCancel = () => {
    options.cancel(false);
  };
  const handleOk = async () => {
    const values = await form.validateFields();
    console.log('values :>> ', values);
  };

  const initialValues = Object.assign(
    {
      saleTimeType: 1,
      saleDates: [],
      saleTimes: [[]],
    },
    options.initialValues,
  );

  return (
    <Modal
      visible={options.visible}
      title="售卖时间"
      onOk={handleOk}
      maskClosable={false}
      destroyOnClose
      onCancel={handleCancel}
    >
      <Form
        name="basic"
        form={form}
        labelCol={{ span: 6 }}
        wrapperCol={{ span: 16 }}
        initialValues={initialValues}
        autoComplete="off"
      >
        <Form.Item
          label="剩余库存"
          name="saleTimeType"
          rules={[{ required: true, message: '请输入剩余库存!' }]}
        >
          <div>1</div>
        </Form.Item>
      </Form>
    </Modal>
  );
});

export default StockModal;
