import React, { useState, useRef, useEffect, useCallback, useMemo } from 'react';
import { Spin, Table, Modal, message, notification } from 'antd';
import { MenuOutlined, HolderOutlined, FormOutlined, CloseCircleOutlined } from '@ant-design/icons';
import { SortableContainer, SortableElement, SortableHandle } from 'react-sortable-hoc';
import { arrayMoveImmutable } from 'array-move';
import GoodsGroup from './components/GoodsGroup';
import { searchList } from '../service';
import styles from '../style.less';
import { takeawayColumn } from '../staticdata';
// import VirtualTable from './components/VirtualTable';
import ActionBar from './components/ActionBar';
import WeekTime from './components/WeekTime';
import StockModal from './components/StockModal';
import SendModal from './components/SendModal';
import MinimumPurchaseModal from './components/MinimumPurchase';

const Takeaway = options => {
  const [tableData, setTableData] = useState([]);
  const [selectedRowKeys, setSelectedRowKeys] = useState([]);
  const [loading, setLoading] = useState(false);
  const [visibleWeekTime, setVisibleWeekTime] = useState(false);
  const [visibleStock, setVisibleStock] = useState(false);
  const [visibleBuy, setVisibleBuy] = useState(false);
  const [visibleSend, setVisibleSend] = useState(false);
  const [visibleSwitchGroup, setVisibleSwitchGroup] = useState(false);

  const rowSelection = {
    selectedRowKeys,
    onChange: setSelectedRowKeys,
  };

  const onSortEnd = ({ oldIndex, newIndex }) => {
    if (oldIndex !== newIndex) {
      const newData = arrayMoveImmutable(tableData.slice(), oldIndex, newIndex).filter(el => !!el);
      setTableData(newData);
    }
  };

  const SortableItem = SortableElement(props => <tr {...props} />);
  const SortableBody = SortableContainer(props => <tbody {...props} />);

  const DraggableContainer = props => (
    <SortableBody
      useDragHandle
      disableAutoscroll
      helperClass={styles['row-dragging']}
      onSortEnd={onSortEnd}
      {...props}
    />
  );

  const DraggableBodyRow = ({ className, style, ...restProps }) => {
    // function findIndex base on Table rowKey props and should always be a right array index
    const index = tableData.findIndex(x => x.skuId === restProps['data-row-key']);
    return <SortableItem index={index} {...restProps} />;
  };

  const getDataList = async () => {
    setLoading(true);
    const res = await searchList({ productType: 1 });
    setLoading(false);
    if (res && res.data) {
      setTableData(res.data.records);
    }
  };

  // 显示弹窗
  const openModal = type => {
    type === 'time' && setVisibleWeekTime(true);
    type === 'stock' && setVisibleStock(true);
    type === 'group' && setVisibleSwitchGroup(true);
    type === 'buy' && setVisibleBuy(true);
    type === 'send' && setVisibleSend(true);
  };

  useEffect(() => {
    getDataList();
  }, []);

  return (
    <div className={styles.takeawayBox}>
      <Spin spinning={loading}>
        <GoodsGroup />
        <ActionBar selectedRowKeys={selectedRowKeys} openModal={openModal} />
        <Table
          dataSource={tableData}
          bordered
          columns={takeawayColumn.call(this)}
          rowKey={record => record.skuId}
          pagination={false}
          scroll={{ x: '100%', y: 1000 }}
          rowSelection={rowSelection}
          components={{
            body: {
              wrapper: DraggableContainer,
              row: DraggableBodyRow,
            },
          }}
        />
      </Spin>
      <WeekTime visible={visibleWeekTime} cancel={setVisibleWeekTime} />
      <StockModal visible={visibleStock} cancel={setVisibleStock} />
      <SendModal visible={visibleSend} cancel={setVisibleSend} />
      <MinimumPurchaseModal visible={visibleBuy} cancel={setVisibleBuy} />
    </div>
  );
};

export default Takeaway;
