import { stringify } from 'querystring';
import _ from 'lodash';
import request from '@/utils/request';
import { saveAs } from 'file-saver';
import { format } from 'date-fns';
import config from '../../../../config/env.config';

// 查询订单列表
export async function queryOrderList(params) {
  return request.post('/api/kdsp/queryOrderList', {
    prefix: config.kdspApi,
    data: params,
  });
}

// 待发货订单
export async function queryToSend(params) {
  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/api/kdsp/op/mch-order/list-v2', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(params, v => !v)),
      headers: {
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });
    return {
      current,
      data: records.map(v => ({ ...v, logisticsStatus: `_${v.logisticsStatus}` })),
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
}

//  发货/更新物流
export async function updateExpress(params) {
  return request.post('/api/kdsp/op/mch-order/update-express-info', {
    prefix: config.kdspApi,
    data: params,
  });
}

// 快递公司
export async function queryExpress() {
  try {
    const { data } = await request.get('/api/kdsp/op/express/list', {
      prefix: config.kdspApi,
    });
    return data;
  } catch (error) {
    return {};
  }
}

export async function getGoods(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}

export async function getLogistics(orderId) {
  const { data } = await request.get(`/api/kdsp/op/mch-order/logistics-skus?orderId=${orderId}`, {
    prefix: config.kdspApi,
  });
  return data;
}
