import React, { useState, forwardRef, useImperativeHandle } from 'react';
import { Modal, Table } from 'antd';
import style from './index.less';

const DetailModal = (props, ref) => {
  const [visible, setVisible] = useState(false);

  const modalProps = {
    visible,
    width: '1000px',
    title: '订单详情',
    footer: null,
    onCancel: () => {
      setVisible(false);
    },
  };
  /** @module 基本信息 */
  const [baseInfo, setBaseInfo] = useState({});

  /** @module 商品table */
  const [goodData, setGoodData] = useState([]);
  const goodColumns = [
    {
      title: '商品',
      dataIndex: 'skuName',
    },
    {
      title: '单价（元）',
      dataIndex: 'supplyPrice',
    },
    {
      title: '数量',
      dataIndex: 'count',
    },
    {
      title: '小计',
      dataIndex: 'skuName',
    },
    {
      title: '售后状态',
      dataIndex: 'afterServiceStatus',
    },
  ];

  /** @module 券码 */
  const [couponData, setCouponData] = useState([]);
  const couponColumns = [
    {
      title: '券码',
      render: (_, record, index) => `券码${index + 1}`,
    },
    {
      title: '有效期',
      dataIndex: 'price',
    },
    {
      title: '核销时间',
      dataIndex: 'count',
    },
    {
      title: '核销人',
      dataIndex: 'skuName',
    },
    {
      title: '状态',
      dataIndex: 'afterStatus',
    },
  ];

  const open = record => {
    console.log(record);
    setVisible(true);
    const {
      skuVos,
      couponCodeVos,
      receiverName,
      receiverMobile,
      fullAddress,
      orderNo,
      orderTime,
      payTime,
    } = record;

    setGoodData(skuVos);
    setCouponData(couponCodeVos);
    setBaseInfo({
      receiverName,
      receiverMobile,
      fullAddress,
      orderNo,
      orderTime,
      payTime,
    });
  };

  useImperativeHandle(ref, () => ({
    open,
  }));

  return (
    <Modal {...modalProps}>
      <div className={style['order-info']}>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>收货人信息</div>
          <ul className={style['order-info--item__ul']}>
            <li>姓名：{baseInfo.receiverName}</li>
            <li>手机号：{baseInfo.receiverMobile}</li>
            <li>地址：{baseInfo.fullAddress}</li>
          </ul>
        </div>
        <div className={style['order-info--item']}>
          <div className={style['order-info--item__title']}>订单信息</div>
          <ul className={style['order-info--item__ul']}>
            <li>订单号：{baseInfo.orderNo}</li>
            <li>下单时间：{baseInfo.orderTime}</li>
            <li>付款时间：{baseInfo.payTime}</li>
          </ul>
        </div>
      </div>

      {/* 商品 */}
      <div className={style['good-table']}>
        <Table
          pagination={false}
          rowKey="orderSkuId"
          bordered
          columns={goodColumns}
          dataSource={goodData}
        ></Table>
      </div>
      {/* 券码 */}
      <div className={style['coupon-table']}>
        <Table pagination={false} bordered columns={couponColumns} dataSource={couponData}></Table>
      </div>
    </Modal>
  );
};

export default forwardRef(DetailModal);
