import React from 'react';
import { Form, Input, Select, DatePicker, Button, Space, notification } from 'antd';
import { sub } from 'date-fns';
import style from './index.less';

const { Option } = Select;
const { RangePicker } = DatePicker;
const SEARCH_TYPE = {
  SELECT: 'select',
  RANGE_PICKER: 'range_picker',
  INPUT: 'input',
};
const FormSearch = props => {
  const {
    width = '100%',
    form,
    initialValues = {},
    onFinish = () => {},
    formConfig,
    formOptions,
    btnConfig,
  } = props;

  const FormItemBox = ({ bindKey, label, column, children, afterRender }) => {
    const columnValue = column;
    // if (afterRender) {
    //   columnValue = '';
    // }
    return (
      <Form.Item
        className={style['custom-form-item']}
        column={columnValue}
        name={bindKey}
        label={label}
      >
        {children}
      </Form.Item>
    );
  };

  // 下拉框类型
  const FormItemSelect = config => {
    const {
      bindKey,
      options: configOptions = [],
      originOptions = {},
      afterRender = null,
      afterOptions = {},
      column,
    } = config;

    // 提取公共部分
    const BaseSelectElement = () => (
      <FormItemBox {...config}>
        <Select name={bindKey} className={style['form-item-tag']} {...originOptions}>
          {configOptions.map(option => (
            <Option key={option.value} value={option.value}>
              {option.name}
            </Option>
          ))}
        </Select>
      </FormItemBox>
    );

    if (afterRender) {
      return (
        <>
          {/* // <div className={style['custom-form-item-group']}> */}
          <BaseSelectElement />
          <FormItemBox column={column} {...afterOptions}>
            {afterRender()}
          </FormItemBox>
          {/* // </div> */}
        </>
      );
    }

    return <BaseSelectElement />;
  };

  // 选择日期范围类型
  const FormItemRangePicker = config => {
    const { originOptions = {} } = config;
    return (
      <FormItemBox {...config}>
        <RangePicker className={style['form-item-tag']} {...originOptions} />
      </FormItemBox>
    );
  };

  // 选择日期

  // 多级联动

  // 输入框类型
  const FormItemInput = config => {
    const { originOptions = {} } = config;
    return (
      <FormItemBox {...config}>
        <Input className={style['form-item-tag']} {...originOptions} />
      </FormItemBox>
    );
  };

  // 表单内容元素
  const FormItemElement = () =>
    formConfig.map(config => {
      const { type } = config;
      switch (type) {
        case SEARCH_TYPE.SELECT:
          return <FormItemSelect key={config.bindKey} {...config} />;
        case SEARCH_TYPE.RANGE_PICKER:
          return <FormItemRangePicker key={config.bindKey} {...config} />;
        case SEARCH_TYPE.INPUT:
          return <FormItemInput key={config.bindKey} {...config} />;
        default:
          return <></>;
      }
    });

  /**
   * @module 按钮操作
   */
  const FormItemButton = () => (
    <Space size={10}>
      {btnConfig.map(config => {
        const { label, onClick = () => {}, type = 'primary', clickType = 'search' } = config;
        const htmlType = clickType === 'reset' ? 'reset' : 'submit';
        const callback = () => {
          setTimeout(() => {
            onClick({ type: clickType, params: form.getFieldValue() });
          });
        };
        return (
          <Button key={clickType} type={type} htmlType={htmlType} onClick={callback}>
            {label}
          </Button>
        );
      })}
    </Space>
  );

  return (
    <div className={style['form-search']}>
      <Form
        style={{ width }}
        layout="inline"
        form={form}
        initialValues={initialValues}
        onFinish={onFinish}
        {...formOptions}
      >
        <FormItemElement></FormItemElement>
        <Form.Item>
          <FormItemButton></FormItemButton>
        </Form.Item>
      </Form>
    </div>
  );
};

export { FormSearch, SEARCH_TYPE };
