import React from 'react';
import { Form, Row, Col, Input } from 'antd';
import { mealType, mealSections } from '../staticData';
import MealLimit from './MealLimit';

/**
 * 渲染 企业单笔消费限额 二维表单项目
 */
const MealLimitsFormList = (meals, selectedMealTypes) => (
  <Form.List name="mealLimit" key="mealLimit">
    {() => (
      <>
        {Object.keys(meals).map((meal, i) => (
          <Row key={`meal${meal}`}>
            <Col span={0}>
              <Form.Item
                label=""
                name={[i, 'mealPeriodType']}
                labelCol={{ span: 0 }}
                wrapperCol={{ span: 0 }}
              >
                <Input type="hidden" value={meal} />
              </Form.Item>
            </Col>
            <Col span={24}>
              <Form.Item
                label={`${mealSections[meal]}订单`}
                required
                labelCol={{ span: 4 }}
                wrapperCol={{ span: 20 }}
              >
                <Form.List name={[i, 'limit']} required wrapperCol={{ span: 21 }}>
                  {() => (
                    <Row key={`row${meal}`}>
                      {selectedMealTypes.map((t, j) => (
                        <Col key={`col${t}`} span={7}>
                          <Row>
                            <Col span={0}>
                              <Form.Item
                                label=""
                                name={[j, 'mealType']}
                                labelCol={{ span: 0 }}
                                wrapperCol={{ span: 0 }}
                              >
                                <Input type="hidden" value={t} />
                              </Form.Item>
                            </Col>
                            <Col span={24} offset={j ? 1 : 0}>
                              <MealLimit label={mealType[t]} name={[j, 'limit']} />
                            </Col>
                          </Row>
                        </Col>
                      ))}
                    </Row>
                  )}
                </Form.List>
              </Form.Item>
            </Col>
          </Row>
        ))}
      </>
    )}
  </Form.List>
);

export default MealLimitsFormList;
