import React, { useContext } from 'react';
import { TaskList } from '../config';
import { ServiceContext } from '../context';
import commonStyle from '../common.less';
import { useLocation } from 'react-router-dom';
import { POP_GOOD_MANAGE } from '@/../config/permission.config';

export const TaskTypeSelect = props => {
  const { permissions } = props;
  const location = useLocation();
  const customer = useContext(ServiceContext);
  const isPopGoods = location.pathname.indexOf('popGoodsManage') > 0; // pop商品管理-商品库(应付审计用的, 驳回和修改状态下不能编辑)
  const typeConfig = !isPopGoods
    ? TaskList(customer.canAddService, customer.canAddNormal, customer.canTakeawayService)
    : TaskList(
        permissions[POP_GOOD_MANAGE.ADD_SERVICE_GOODS],
        permissions[POP_GOOD_MANAGE.ADD_NORMAL_GOODS],
        permissions[POP_GOOD_MANAGE.ADD_TAKEAWAY_GOODS],
      );
  const selectTabs = task => {
    if (!customer.isEdit && Object.keys(props.takeAway).length === 0) {
      props.onChange(task);
    }
  };

  return (
    <div className={commonStyle.prodcutContent}>
      {typeConfig.map(task => {
        const activeClassName = props.productType === task.type ? commonStyle.activeCard : '';
        if (task.hide) return null;
        return (
          <dl
            key={task.type}
            onClick={() => selectTabs(task)}
            className={`${commonStyle.productCard} ${activeClassName}`}
          >
            <dd className="prodcut-name">{task.name}</dd>
            <dd className="prodcut-desc">({task.desc})</dd>
          </dl>
        );
      })}
    </div>
  );
};
