import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { goodsApi, apiPrefix, keystoneApi } = config;
// [企业店铺]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65284
export const setShopList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/list`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-删除企业下面的店铺
// http://yapi.quantgroups.com/project/389/interface/api/65319
export const setShopDelete = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/delete`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-查询餐品类型
// http://yapi.quantgroups.com/project/389/interface/api/65314
export const mealTypeList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/mealType/list`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-添加企业店铺
// http://yapi.quantgroups.com/project/389/interface/api/65304
export const shopAdd = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/add`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// 企业店铺]-修改餐品类型
// http://yapi.quantgroups.com/project/389/interface/api/65309
export const apiShopUpdate = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/update`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业客户]-列表查询
// http://yapi.quantgroups.com/project/389/interface/api/65324
export const apiEnterpriseList = async () => {
  const data = await request.post(`${apiPrefix}/enterprise/pageList`, {
    prefix: keystoneApi,
    data: {
      page: 1,
      size: 10000,
    },
  });
  return data;
};
// [企业店铺]-可选择店铺列表
// http://yapi.quantgroups.com/project/389/interface/api/65524
export const apiSelectList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/select/list`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-添加企业店铺校验是否是到店类型
// http://yapi.quantgroups.com/project/389/interface/api/65304
export const busineesTypeCheck = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/busineesType/check`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-添加企业店铺
// http://yapi.quantgroups.com/project/389/interface/api/65304
export const apiShopAdd = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/add`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};

// [企业店铺]-企业已选的店铺
// http://yapi.quantgroups.com/project/389/interface/api/65534
export const apiSelectedList = async params => {
  const data = await request.post(`${apiPrefix}/enterprise/shop/selected/list`, {
    prefix: goodsApi,
    data: params,
  });
  return data;
};
