import React from 'react';
import { Button, Input } from 'antd';
import UploadImage from '@/components/UploadImg/index.jsx';

// 品牌审核状态 0待审核 1审核通过 2驳回
export const brandStatusEnum = {
  0: '待审核',
  1: '审核通过',
  2: '驳回',
};
// 品牌审核 1审核通过 2驳回
export const brandAuditEnum = {
  1: '审核通过',
  2: '驳回',
};
// 操作状态 审核、查看、修改、添加、补充资质
export const brandActionAudit = 'audit';
export const brandActionFind = 'find';
export const brandActionEdit = 'edit';
export const brandActionAdd = 'add';
export const brandActionSupplement = 'supplement';

export const brandBaseColumn = [
  {
    title: '品牌名称',
    dataIndex: 'brandName',
    key: 'brandName',
  },
  {
    title: '中文名称',
    dataIndex: 'chineseName',
    key: 'chineseName',
    hideInSearch: true,
    align: 'center',
  },
  {
    title: '英文名称',
    key: 'englishName',
    dataIndex: 'englishName',
    hideInSearch: true,
    align: 'center',
  },
  {
    title: '品牌缩写或别称',
    key: 'alias',
    dataIndex: 'alias',
    hideInSearch: true,
    align: 'center',
  },
];

// 品牌列表字段
export const brandColumn = config => {
  const { onAction } = config;
  return [
    ...brandBaseColumn,
    {
      title: '审核状态',
      key: 'status',
      dataIndex: 'status',
      align: 'center',
      valueEnum: brandStatusEnum,
    },
    {
      title: '操作',
      hideInSearch: true,
      dataIndex: 'option',
      align: 'center',
      width: 200,
      render: (_, r) => [
        <Button key="check" type="primary" onClick={() => onAction(r, 'edit')}>
          修改
        </Button>,
        <Button key="update" type="primary" ghost onClick={() => onAction(r, 'update')}>
          补充资质
        </Button>,
      ],
    },
  ];
};

// 品牌信息字段
export const brandInfoColumn = config => {
  const { actionStatus } = config;
  const disabled = [brandActionAudit, brandActionFind].includes(actionStatus);
  const baseInfo = [
    {
      title: '资质证书',
      dataIndex: 'qualifyUrl',
      formItemProps: {
        rules: [{ required: true, message: '请选择资质证书' }],
      },
      fieldProps: {
        disabled,
      },
      renderFormItem: () => <UploadImage limit={1} />,
    },
    {
      title: '授权证书',
      dataIndex: 'authorizationUrl',
      formItemProps: {
        rules: [{ required: true, message: '请选择授权证书' }],
      },
      fieldProps: {
        disabled,
      },
      renderFormItem: () => <UploadImage limit={1} />,
    },
    {
      title: '品牌名称',
      dataIndex: 'name',
      maxLength: 50,
      fieldProps: {
        disabled,
      },
      formItemProps: {
        rules: [{ required: true, message: '请输入品牌名称' }],
      },
    },
    {
      title: '中文名称',
      dataIndex: 'chineseName',
      maxLength: 50,
      fieldProps: {
        disabled,
      },
    },
    {
      title: '英文名称',
      dataIndex: 'englishName',
      maxLength: 100,
      fieldProps: {
        disabled,
      },
    },
    {
      title: '品牌缩写或别称',
      dataIndex: 'alias',
      maxLength: 50,
      formItemProps: {
        rules: [{ required: true, message: '请输入品牌缩写或别称' }],
      },
      fieldProps: {
        disabled,
      },
    },
    {
      title: '长方形LOGO上传',
      dataIndex: 'horizontalLogo',
      formItemProps: {
        rules: [{ required: true, message: '请上传长方形LOGO上传' }],
        extra: (
          <div>
            <div>尺寸要求:219*72</div>
            <div>
              素材要求：1、透明底；2、上下左右最少留白2px，具体以保证整体大小一致，视觉平衡为准
            </div>
          </div>
        ),
      },
      fieldProps: {
        disabled,
      },
      renderFormItem: () => <UploadImage limit={1} width={219} height={72} />,
    },
    {
      title: 'LOGO上传',
      dataIndex: 'logo',
      formItemProps: {
        rules: [{ required: true, message: '请上传LOGO' }],
        extra: <span>尺寸要求:192*192</span>,
      },
      fieldProps: {
        disabled,
      },
      renderFormItem: () => <UploadImage limit={1} width={192} height={192} />,
    },
    {
      title: '',
      dataIndex: '',
      valueType: 'divider',
      hideInForm: ![brandActionAudit, brandActionFind].includes(actionStatus),
      formItemProps: {
        wrapperCol: { span: 22 },
      },
      fieldProps: {
        children: '品牌审核',
        orientation: 'left',
      },
    },
    {
      title: '审核结果',
      dataIndex: 'status',
      valueType: 'radio',
      hideInForm: ![brandActionAudit, brandActionFind].includes(actionStatus),
      valueEnum: brandAuditEnum,
      fieldProps: {
        buttonStyle: 'outline',
        disabled: [brandActionFind].includes(actionStatus),
        onChange: e => {
          if (e.target.value === 2) {
            config.form.setFieldsValue({ reason: '' });
          }
        },
      },
    },
    {
      valueType: 'dependency',
      name: ['status'],
      hideInForm: ![brandActionAudit, brandActionFind].includes(actionStatus),
      columns: ({ status }) => {
        const rejectColumn = [
          {
            title: '驳回原因',
            dataIndex: 'rejectReason',
            maxLength: 200,
            formItemProps: {
              rules: [{ required: true, message: '请输入驳回原因' }],
            },
            fieldProps: {
              placeholder: '请输入驳回原因',
              disabled: [brandActionFind].includes(actionStatus),
            },
            renderFormItem: () => <Input />,
          },
        ];
        return +status === 2 ? rejectColumn : [];
      },
    },
  ];
  return baseInfo;
};
