import { stringify } from 'querystring';
import request from '@/utils/request';

export async function fakeAccountLogin(params) {
  return request('/v2/oauth/login', {
    method: 'POST',
    data: stringify(params),
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
  });
}
export async function getFakeCaptcha(mobile) {
  return request(`/v2/user/captcha?mobile=${mobile}`);
}
export async function getResFreshToen(token) {
  return request(`/v2/oauth/refreshtoken?refreshtoken=${token}`);
}
// 商户后台密码修改-校验
export async function passwordRule(params) {
  return request.post('/v2/user/password/validate', {
    data: params,
  });
}

// 商户后台密码修改
export async function resetPassword(params) {
  const data = await request.post('/v2/user/password/reset', { data: params });
  return data;
}
