import { Button, Tag } from 'antd';
import React from 'react';

export const refuseReasonEnum = {
  0: { text: '待操作' },
  1: { text: '已同意' },
  2: { text: '已拒绝' },
};

export function columns(res) {
  const { openAudit, openDetail, openImgModal } = res;
  return [
    {
      title: '售后申诉单ID',
      width: 300,
      dataIndex: 'appealNo',
      key: 'appealNo',
    },
    {
      title: '售后单ID',
      width: 300,
      dataIndex: 'serviceNo',
      key: 'serviceNo',
    },
    {
      title: '订单ID',
      width: 200,
      dataIndex: 'orderNo',
      key: 'orderNo',
      render: (orderNo, row) => (
        <Tag color={row.timeout ? 'red' : 'green'} key={orderNo}>
          {orderNo}
        </Tag>
      ),
    },
    {
      title: '申诉单开始时间',
      width: 120,
      dataIndex: 'startDate',
      key: 'startDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '申诉单结束时间',
      width: 120,
      dataIndex: 'endDate',
      key: 'endDate',
      valueType: 'date',
      hideInTable: true,
    },
    {
      title: '商家名称',
      width: 120,
      dataIndex: 'merchantName',
      key: 'merchantName',
      hideInSearch: true,
    },
    {
      title: '商家手机号',
      width: 120,
      dataIndex: 'merchantPhone',
      key: 'merchantPhone',
      hideInSearch: true,
    },
    {
      title: '商家退款地址',
      width: 120,
      dataIndex: 'merchantAddress',
      key: 'merchantAddress',
      hideInSearch: true,
    },
    {
      title: '是否同意售后',
      width: 120,
      dataIndex: 'isAgree',
      key: 'isAgree',
      hideInSearch: true,
    },
    {
      title: '商家拒绝原因',
      width: 120,
      dataIndex: 'serviceReason',
      key: 'serviceReason',
      hideInSearch: true,
    },
    {
      title: '售后凭证',
      width: 120,
      dataIndex: 'proofs',
      key: 'proofs',
      hideInSearch: true,
      render: proofs => {
        const list = proofs && proofs !== '-' ? proofs.split(',') : [];
        return <a onClick={() => openImgModal(list)}>查看凭证</a>;
      },
    },
    {
      title: '申诉单创建时间',
      width: 120,
      dataIndex: 'appealTime',
      key: 'appealTime',
      hideInSearch: true,
    },
    {
      title: '申诉单超时时间',
      width: 120,
      dataIndex: 'overtime',
      key: 'overtime',
      hideInSearch: true,
    },
    {
      title: '争议问题描述',
      width: 120,
      dataIndex: 'disputeDesc',
      key: 'disputeDesc',
      hideInSearch: true,
    },
    {
      title: '补充资料',
      width: 120,
      dataIndex: 'supplement',
      key: 'supplement',
      hideInSearch: true,
      render: supplement => {
        const list = supplement && supplement !== '-' ? supplement.split(',') : [];
        return <a onClick={() => openImgModal(list)}>查看补充资料</a>;
      },
    },
    {
      title: '协商结果',
      width: 120,
      dataIndex: 'appealResult',
      key: 'appealResult',
      hideInSearch: true,
      valueEnum: refuseReasonEnum,
    },
    {
      title: '售后申诉拒绝原因',
      width: 120,
      dataIndex: 'refuseReason',
      key: 'refuseReason',
      hideInSearch: true,
    },
    {
      title: '操作',
      width: 220,
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      render: (_, row) => [
        <Button disabled={!row.showAudit} type="primary" onClick={() => openAudit(row)}>
          审核
        </Button>,
        <Button disabled={!row.showDetail} type="primary" onClick={() => openDetail(row)}>
          查看详情
        </Button>,
      ],
    },
  ];
}
