const isProduction = process.env.NODE_ENV === 'production';
const isPre = process.env.PRE_ENV === 'pre';
const environment = 'sc';

// 从tob进入的判断接口前缀
const getUrlParams = name => {
  const regArg = new RegExp(`(^|&)${name}=([^&]*)(&|$)`);
  const r = window.location.search.substring(1).match(regArg);
  if (r != null) return decodeURIComponent(r[2]);
  return null;
};
const isPlatForm = +getUrlParams('isMaster') === 1;
const apiPrefix = isPlatForm ? '/api/consoles' : '/api/merchants';

const envAPi = {
  api: `https://security-${environment}.liangkebang.net`, //'https://security-xyqb.liangkebang.net',
  kdspOpApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  kdspApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  goodsApi: `https://sc-merchant-api-${environment}.liangkebang.net`,
  querysApi: `https://sc-merchant-api-${environment}.liangkebang.net/admin/merchant/sc-settlement`,
  prologueDomain: `https://mall-${environment}.liangkebang.net`,
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  opapiHost: `https://gw.yxmie.com`,
  wsApi: `wss://push-${environment}.liangkebang.net`,
  msgApi: `https://msgapi-${environment}.liangkebang.net`,
  keystoneApi: `https://sc-op-api-${environment}.liangkebang.net`,
  roleApi: isPlatForm
    ? `https://sc-op-api-${environment}.liangkebang.net`
    : `https://sc-merchant-api-${environment}.liangkebang.net`,
  apiPrefix,
};

const prodApi = {
  api: '//security.q-gp.com',
  kdspOpApi: '//kdsp-operation.q-gp.com',
  prologueDomain: '//mall.q-gp.com',
  kdspApi: 'https://sc-merchant-api.q-gp.com',
  // goodsApi: 'https://sc-op-api.q-gp.com', // 测试环境打包域名，
  goodsApi: 'https://sc-merchant-api.q-gp.com', // 线上环境打包域名
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  //  talos  后面要下线
  opapiHost: '//gw.yxmie.com',
  // opapiHost: 'https://opapi.q-gp.com',
  // querysApi: 'https://sc-settlement-api.q-gp.com',
  querysApi: 'https://sc-merchant-api.q-gp.com/admin/merchant/sc-settlement',
  wsApi: 'wss://push.q-gp.com',
  msgApi: 'https://msgapi.q-gp.com',
  keystoneApi: '//sc-op-api.q-gp.com',
  roleApi: isPlatForm ? 'https://sc-op-api.q-gp.com' : 'https://sc-merchant-api-pre.q-gp.com',
  apiPrefix,
};

const preProdApi = {
  api: '//backstms-pre.xyqb.com',
  kdspOpApi: '//kdsp-operation-pre.q-gp.com',
  prologueDomain: '//mall.q-gp.com',
  kdspApi: '//sc-op-api-pre.q-gp.com',
  goodsApi: 'https://sc-merchant-api-pre.q-gp.com',
  qiniuHost: 'https://kdspstatic.q-gp.com/',
  opapiHost: 'https://opapi-pre.q-gp.com',
  querysApi: 'https://sc-settlement-api.q-gp.com',
  wsApi: 'wss://push.q-gp.com',
  msgApi: 'https://msgapi.q-gp.com',
  keystoneApi: '//sc-op-api-pre.q-gp.com',
  roleApi: isPlatForm ? 'https://sc-op-api-pre.q-gp.com' : 'https://sc-merchant-api-pre.q-gp.com',
  apiPrefix,
};

let exportApi = envAPi;
if (isPre) {
  exportApi = preProdApi;
} else if (isProduction) {
  exportApi = prodApi;
}
module.exports = exportApi;

// let exportApi;
// isProduction ? (exportApi = prodApi) : (exportApi = envAPi);

// export default exportApi;
