import React from 'react';
import { Modal, Row, Col, Input } from 'antd';

const { TextArea } = Input;
const AppealDetail = props => {
  const { modalVisible, onCancel, data } = props;
  return (
    <Modal
      destroyOnClose
      title="查看详情"
      width="800px"
      visible={modalVisible}
      onCancel={() => onCancel()}
      onOk={() => onCancel()}
      bodyStyle={{ maxHeight: '600px', minHeight: '200px', overflow: 'auto' }}
      footer={[]}
    >
      {data ? (
        <div>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>申诉单ID:{data.appealNo}</p>
            </Col>
            <Col span={12}>
              <p>订单ID:{data.orderNo}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>售后单ID:{data.serviceNo}</p>
            </Col>
            <Col span={12}>
              <p>商家名称:{data.merchantName}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>商家手机号:{data.merchantPhone}</p>
            </Col>
            <Col span={12}>
              <p>商家退货地址:{data.merchantAddress}</p>
            </Col>
          </Row>
          <Row gutter={[10, 20]}>
            <Col span={12}>
              <p>是否同意售后:{data.isAgree}</p>
            </Col>
            <Col span={12}>
              <p>商家拒绝原因:{data.serviceReason}</p>
            </Col>
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={3}>售后凭证：</Col>
            {data.proofs &&
              data.proofs.split(',').map(item => (
                <Col key={item}>
                  <img key={item} width="100%" src={item} alt="" />
                </Col>
              ))}
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={5}>争议问题描述</Col>
            <Col span={16}>
              <TextArea value={data.disputeDesc} />
            </Col>
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={5}>补充资料：</Col>
            {data.supplement &&
              data.supplement.split(',').map(item => (
                <Col key={item}>
                  <img src={item} key={item} alt="" />
                </Col>
              ))}
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={3}>协商结果：</Col>
            <Col span={8}>{data.appealResult}</Col>
            <Col span={5}>售后申诉拒绝原因：</Col>
            <Col span={8}>{data.refuseReason}</Col>
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 30]}>
            <Col span={4}>商家退货地址：</Col>
            <Col span={16}>{data.merchantAddress}</Col>
          </Row>
          <Row type="flex" justify="start" align="middle" gutter={[10, 20]}>
            <Col span={3}>商家姓名：</Col>
            <Col span={8}>{data.merchantAddress}</Col>
            <Col span={3}>商家手机号：</Col>
            <Col span={8}>{data.merchantPhone}</Col>
          </Row>
        </div>
      ) : (
        '暂无物流信息'
      )}
    </Modal>
  );
};

export default AppealDetail;
