import React, { useState, useRef } from 'react';
import { notification, Button } from 'antd';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { searchList, auditInfoApi, jdInfo } from '../services';
import { columnSticData, appealType } from '../data';
import AuditModal from '../components/auditModal';
import DetailTable from '../components/detailTable';
import ProofsModal from '../components/proofsModal';
import { getDetail } from '../../afterSale/appeal/services';
import Detail from '../../afterSale/components/detail';

export default () => {
  const table = useRef();
  const [visible, setVisible] = useState(false);
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const [proofsVisible, setProofsVisible] = useState(false);
  const [proofsData, setProofsData] = useState([]);
  const [auditInfo, setAuditInfo] = useState({});
  const [detailModal, setDetailModal] = useState(false);
  const [selectedRow, setSelectedRow] = useState({});

  const viewDetail = async ({ serviceNo }) => {
    const data = await jdInfo({ serviceNo });
    setDetailInfo(data?.skuQuantity || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
    setProofsVisible(false);
  };
  const openAudit = async ({ serviceNo }) => {
    const data = await auditInfoApi({ serviceNo });
    setAuditInfo({ ...data?.data, serviceNo });
    setVisible(true);
  };
  const viewProofs = proofs => {
    if (!proofs) {
      notification.warning({ message: '该订单没有凭证' });
      return;
    }
    setProofsData(proofs.split(','));
    setProofsVisible(true);
  };
  const viewAppeal = async r => {
    const detailData = await getDetail({ appealNo: r.appealNo });
    setDetailModal(true);
    setSelectedRow(detailData);
  };
  const columns = [
    ...columnSticData,
    {
      title: '售后凭证',
      dataIndex: 'proofs',
      hideInSearch: true,
      order: 4,
      width: 100,
      render: proofs => <a onClick={() => viewProofs(proofs)}>查看凭证</a>,
    },
    {
      title: '售后申诉',
      dataIndex: 'appealFlag',
      valueEnum: appealType,
      hideInSearch: true,
      width: 120,
      render: (appealFlag, r) => {
        if (appealFlag) {
          return <a onClick={() => viewAppeal(r)}>已申诉</a>;
        }
        return <div>未申诉</div>;
      },
    },
    {
      title: '操作',
      hideInSearch: true,
      width: 250,
      fixed: 'right',
      render: (_, r) => [
        <Button key="link1" onClick={() => openAudit(r)} className="mr10" type="primary">
          审核
        </Button>,
        <Button key="link" onClick={() => viewDetail(r)} type="primary">
          订单详情
        </Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        columns={columns}
        request={params => searchList(params, 1)}
        rowKey="orderNo"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%' }}
        search={{
          collapsed: false,
        }}
      />
      <AuditModal visible={visible} onCancel={closeModal} formData={auditInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
      <ProofsModal visible={proofsVisible} onCancel={closeModal} data={proofsData} />
      <Detail data={selectedRow} modalVisible={detailModal} onCancel={closeModal}></Detail>
    </PageHeaderWrapper>
  );
};
