import React, { useState, useRef } from 'react';
import { Button, notification, Popconfirm } from 'antd';
import ProTable from '@ant-design/pro-table';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { searchList, shopCheck, jdInfo, trackInfo } from '../services';
import { getDetail } from '../../afterSale/appeal/services';
import { columnPassAudit } from '../data';
import RejectModal from '../components/rejectModal';
import DetailTable from '../components/detailTable';
import ProofsModal from '../components/proofsModal';
import LogisticsCom from '../../orderManage/pendingDeliveryOrder/components/LogisticsCom';
import Detail from '../../afterSale/components/detail';

export default () => {
  const table = useRef();
  const [visible, setVisible] = useState(false);
  const [detailVisible, setDetailVisible] = useState(false);
  const [detailInfo, setDetailInfo] = useState([]);
  const [proofsVisible, setProofsVisible] = useState(false);
  const [proofsData, setProofsData] = useState([]);
  const [serviceNoInfo, setServiceNoInfo] = useState({});
  const [LogisticsComList, setLogisticsComList] = useState({});
  const [LogisticsComModalVisible, handleComModalVisible] = useState(false);
  const [detailModal, setDetailModal] = useState(false);
  const [selectedRow, setSelectedRow] = useState({});
  const viewDetail = async ({ serviceNo }) => {
    const data = await jdInfo({ serviceNo });
    setDetailInfo(data?.skuQuantity || []);
    setDetailVisible(true);
  };
  const closeModal = isReload => {
    if (isReload === true) {
      // eslint-disable-next-line no-unused-expressions
      table.current?.reload?.();
    }
    setVisible(false);
    setDetailVisible(false);
    setProofsVisible(false);
    handleComModalVisible(false);
  };
  const reject = async ({ serviceNo }) => {
    setServiceNoInfo(serviceNo);
    setVisible(true);
  };
  const viewProofs = proofs => {
    if (!proofs) {
      notification.warning({ message: '该订单没有凭证' });
      return;
    }
    setProofsData(proofs.split(','));
    setProofsVisible(true);
  };
  const refund = async ({ serviceNo }) => {
    const data = await shopCheck({
      serviceNo,
      auditResult: 1,
    });
    if (data.businessCode === '0000') {
      notification.success({ message: '操作成功' });
      closeModal(true);
    }
  };
  const handleCom = async ({ companyCode, logisticsNo }) => {
    const tempObj = {
      expressCompanyCode: companyCode,
      expressCompanyName: companyCode,
      deliveryNo: logisticsNo,
      detailList: [],
      key: Date.now(),
    };
    const data = await trackInfo({ companyCode, logisticsNo });
    if (!data) {
      notification.info({ message: '暂无物流信息' });
      return;
    }
    if (data.logisticsList?.length) {
      data.logisticsList.forEach(v => {
        tempObj.detailList = [...tempObj.detailList, ...v.detailList];
      });
    }
    handleComModalVisible(true);
    setLogisticsComList(tempObj);
  };
  const viewAppeal = async r => {
    const detailData = await getDetail({ appealNo: r.appealNo });
    setDetailModal(true);
    setSelectedRow(detailData);
  };
  const columns = [
    ...columnPassAudit,
    {
      title: '售后凭证',
      dataIndex: 'proofs',
      hideInSearch: true,
      width: 120,
      order: 4,
      render: proofs => <a onClick={() => viewProofs(proofs)}>查看凭证</a>,
    },
    {
      title: '售后申诉',
      dataIndex: 'appealFlag',
      hideInSearch: true,
      width: 120,
      render: (appealFlag, r) => {
        if (appealFlag) {
          return <a onClick={() => viewAppeal(r)}>申诉</a>;
        }
        return <div> 未申诉</div>;
      },
    },
    {
      title: '操作',
      hideInSearch: true,
      width: 450,
      fixed: 'right',
      render: (_, r) => [
        <Popconfirm
          title="确定允许退款？"
          onConfirm={() => refund(r)}
          okText="确认"
          cancelText="取消"
          disabled={!r.showRefund || !r.showRefunded}
        >
          <Button
            key="link1"
            className="mr10"
            type="primary"
            disabled={!r.showRefund || !r.showRefunded}
          >
            {r.showRefunded ? '已退款' : '允许退款'}
          </Button>
        </Popconfirm>,
        <Button
          key="link2"
          onClick={() => reject(r)}
          type="primary"
          className="mr10"
          disabled={!r.showRefuse}
        >
          驳回
        </Button>,
        <Button key="link3" onClick={() => viewDetail(r)} type="primary" className="mr10">
          订单详情
        </Button>,
        <Button
          key="link4"
          onClick={() => handleCom(r)}
          type="primary"
          className="mr10"
          disabled={!r.showLogistics}
        >
          查看物流
        </Button>,
      ],
    },
  ];
  return (
    <PageHeaderWrapper>
      <ProTable
        columns={columns}
        request={params => searchList(params, 2)}
        rowKey="orderNo"
        pagination={{
          pagesSize: 20,
        }}
        bordered
        actionRef={table}
        scroll={{ x: '100%' }}
        search={{
          collapsed: false,
        }}
      />
      <RejectModal visible={visible} onCancel={closeModal} serviceNo={serviceNoInfo} />
      <DetailTable visible={detailVisible} onCancel={closeModal} dataSource={detailInfo} />
      <ProofsModal visible={proofsVisible} onCancel={closeModal} data={proofsData} />
      <LogisticsCom
        onSubmit={closeModal}
        onCancel={closeModal}
        modalVisible={LogisticsComModalVisible}
        value={LogisticsComList}
        key={LogisticsComList.key}
      />
      <Detail data={selectedRow} modalVisible={detailModal} onCancel={closeModal}></Detail>
    </PageHeaderWrapper>
  );
};
