import React from 'react';
import { Image as ImageComponent, Button, Switch } from 'antd';
import { FormOutlined } from '@ant-design/icons';

export const repastTypeList = [
  {
    value: 0,
    label: '拉黑',
  },
  {
    value: 1,
    label: '正常',
  },
];

export const columns = props => [
  {
    title: '部门名称',
    key: 'departmentName',
    dataIndex: 'departmentName',
    align: 'center',
  },
  {
    title: '员工姓名',
    key: 'staffName',
    dataIndex: 'staffName',
    align: 'center',
  },
  {
    title: '员工手机号',
    key: 'mobile',
    dataIndex: 'mobile',
    align: 'center',
  },
  {
    title: '员工状态',
    key: 'isBlack',
    dataIndex: 'isBlack',
    align: 'center',
    render: _ => (_ ? '拉黑' : '正常'),
  },
  {
    title: '余额/券状态',
    key: 'balanceBackFlag',
    dataIndex: 'balanceBackFlag',
    align: 'center',
    render: _ => (_ ? '是' : '否'),
  },
  {
    title: '是否消费限额',
    key: 'isLimit',
    dataIndex: 'isLimit',
    align: 'center',
    width: '150px',
    render: (_, row) => (
      <>
        <Switch defaultChecked={row?.isLimit} onChange={val => props.handleLimitChange(val, row)} />
        &nbsp;<span>{row?.isLimit ? '已开启' : '已关闭'}</span>
      </>
    ),
  },
  {
    title: '员工企业余额',
    key: 'balanceBackFlag',
    dataIndex: 'balanceBackFlag',
    align: 'center',
  },
  {
    title: '有效餐券张数',
    key: 'couponCount',
    dataIndex: 'couponCount',
    align: 'center',
  },
  {
    title: '操作',
    dataIndex: 'option',
    valueType: 'option',
    align: 'center',
    key: 'option',
    render: (_, row) => [
      <Button type="link" onClick={() => props.goDetails(row)}>
        余额充值明细
      </Button>,
      <Button type="link" disabled={!row?.isBlack} onClick={() => props.delEmployee(row)}>
        删除
      </Button>,
    ],
  },
];
