import RoleType, { isPlatForm } from './role.config';
const isProduction = process.env.NODE_ENV === 'production';
const isPre = process.env.PRE_ENV === 'pre';
const environment = 'sc';

const envAPi = {
  api: `https://security-${environment}.op1po.net`, //'https://security-op9po.op1po.net',
  kdspOpApi: `https://sc-merchant-api-${environment}.op1po.net`,
  kdspApi: `https://sc-merchant-api-${environment}.op1po.net`,
  goodsApi: `https://sc-merchant-api-${environment}.op1po.net`,
  querysApi: `https://sc-merchant-api-${environment}.op1po.net/admin/merchant/sc-settlement`,
  prologueDomain: `https://mall-${environment}.op1po.net`,
  qiniuHost: 'https://kdspstatic.op4po.com/',
  opapiHost: `https://gw.yxmie.com`,
  wsApi: `wss://push-${environment}.op1po.net`,
  msgApi: `https://msgapi-${environment}.op1po.net`,
  roleApi: isPlatForm
    ? `https://sc-op-api-${environment}.op1po.net`
    : `https://sc-merchant-api-${environment}.op1po.net`,
};

const prodApi = {
  api: '//security.op4po.com',
  kdspOpApi: '//kdsp-operation.op4po.com',
  prologueDomain: '//mall.op4po.com',
  kdspApi: 'https://sc-merchant-api.op4po.com',
  // goodsApi: 'https://sc-op-api.op4po.com', // 测试环境打包域名，
  goodsApi: 'https://sc-merchant-api.op4po.com', // 线上环境打包域名
  qiniuHost: 'https://kdspstatic.op4po.com/',
  //  talos  后面要下线
  opapiHost: '//gw.yxmie.com',
  // opapiHost: 'https://opapi.op4po.com',
  // querysApi: 'https://sc-settlement-api.op4po.com',
  querysApi: 'https://sc-merchant-api.op4po.com/admin/merchant/sc-settlement',
  wsApi: 'wss://push.op4po.com',
  msgApi: 'https://msgapi.op4po.com',
  roleApi: isPlatForm ? 'https://sc-op-api.op4po.com' : 'https://sc-merchant-api.op4po.com',
};

const preProdApi = {
  api: '//backstms-pre.op9po.com',
  kdspOpApi: '//kdsp-operation-pre.op4po.com',
  prologueDomain: '//mall.op4po.com',
  kdspApi: '//sc-op-api-pre.op4po.com',
  goodsApi: 'https://sc-merchant-api-pre.op4po.com',
  qiniuHost: 'https://kdspstatic.op4po.com/',
  opapiHost: 'https://opapi-pre.op4po.com',
  querysApi: 'https://sc-settlement-api.op4po.com',
  wsApi: 'wss://push.op4po.com',
  msgApi: 'https://msgapi.op4po.com',
  roleApi: isPlatForm ? 'https://sc-op-api-pre.op4po.com' : 'https://sc-merchant-api-pre.op4po.com',
};

let json = envAPi;
if (isPre) {
  json = preProdApi;
} else if (isProduction) {
  json = prodApi;
}
const exportApi = Object.assign({}, RoleType, json);
// module.exports = exportApi;

// let exportApi;
// isProduction ? (exportApi = prodApi) : (exportApi = envAPi);

export default exportApi;
