import React from 'react';
import { Form, Row, Col, TimePicker, Space } from 'antd';
import { mealSections } from '../staticData/index';
import MealCheckbox from './MealCheckbox';

const MealSection = props => (
  <Form.List name="mealTimePeriod">
    {fields => (
      <>
        {Object.keys(mealSections).map((field, i) => (
          <Row key={field} align="baseline">
            <Col span={4}>
              <Form.Item label="" name={[i, 'mealPeriodType']}>
                <MealCheckbox
                  changeType={e => props.onChangeSection(e, props)}
                  meals={props.meals}
                  field={field}
                />
              </Form.Item>
            </Col>
            <Col span={18}>
              <Form.Item
                name={[i, 'time']}
                rules={
                  props.meals[field]
                    ? [
                        { type: 'array', required: true, message: '请选择!' },
                        { validator: props.validateMeals, message: '时间段不能交叉！' },
                      ]
                    : []
                }
              >
                <TimePicker.RangePicker format="HH:mm" minuteStep={30} />
              </Form.Item>
            </Col>
          </Row>
        ))}
      </>
    )}
  </Form.List>
);

export default MealSection;
