import React from 'react';
import { Button } from 'antd';
import styles from './style.less';

export const payStateEnum = {
  1: { text: '待申请' },
  2: { text: '待审批' },
  3: { text: '已通过' },
  4: { text: '待打款' },
  5: { text: '已打款' },
};

export const orderStateNum = {
  1: { text: '待上传' },
  2: { text: '待审核' },
  3: { text: '未通过' },
  4: { text: '已通过' },
};

export const redInvoiceState = {
  1: { text: '是', actionValue: 2 },
  2: { text: '否', actionValue: 1 },
};

export function columns(res, pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: '序号',
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: '供应商名称',
      dataIndex: 'supplierName',
      width: '150px',
      hideInSearch: true,
    },
    {
      title: '付款单批次号',
      dataIndex: 'payBatchNo',
      width: '160px',
    },
    {
      title: '付款单生成日期',
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: '打款日期',
      key: 'payTimeRange',
      dataIndex: 'payAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: '帐单确认周期',
      dataIndex: 'createdAtRange',
      key: 'created',
      hideInSearch: true,
      align: 'center',
      width: '160px',
      render: (text, record) => `${record.billPeriodStart}-${record.billPeriodEnd}`,
    },
    {
      title: '付款单生成日期',
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: '销售总额',
      dataIndex: 'saleAmount',
      width: '100px',
      hideInSearch: true,
    },
    {
      title: '退款总额',
      dataIndex: 'refundAmount',
      width: '100px',
      hideInSearch: true,
    },
    {
      title: '红字金额',
      dataIndex: 'pastRefundAmount',
      width: '100px',
      hideInSearch: true,
    },
    {
      title: '蓝字金额',
      dataIndex: 'currentRefundAmount',
      width: '100px',
      hideInSearch: true,
    },
    {
      title: '应付金额',
      dataIndex: 'payableAmount',
      width: '100px',
      hideInSearch: true,
    },
    {
      title: '是否缺少红字发票',
      dataIndex: 'redInvoiceState',
      valueEnum: redInvoiceState,
    },
    {
      title: '付款状态',
      dataIndex: 'payState',
      valueEnum: payStateEnum,
      width: '110px',
    },
    {
      title: '发票状态',
      dataIndex: 'blueInvoiceState',
      valueEnum: orderStateNum,
      width: '110px',
    },
    {
      title: '操作',
      dataIndex: 'option',
      valueType: 'option',
      key: 'option',
      align: 'center',
      fixed: 'right',
      width: 200,
      render: (_, row) => (
        <div>
          <Button
            type="primary"
            disabled={row.payState !== 1}
            className={styles.button}
            onClick={() => res.edit(0, row)}
          >
            申请结算
          </Button>
          <Button
            type="primary"
            disabled={
              (row.blueInvoiceState === 1 || row.blueInvoiceState === 3) && row.payState === 3
            }
            className={styles.button}
            onClick={() => res.edit(1, row)}
          >
            上传发票
          </Button>
          <Button
            type="primary"
            disabled={row.blueInvoiceState === 1}
            className={styles.button}
            onClick={() => res.edit(2, row)}
          >
            查看发票
          </Button>
          <Button type="primary" className={styles.button} onClick={() => res.edit(3, row)}>
            下载账单
          </Button>
        </div>
      ),
    },
  ];
}

export const toolBarRender = onExport => () => [];
