import { Form, Modal, Input, Select, Cascader, Tag, notification } from 'antd';
import { da } from 'date-fns/locale';
import React, { useState, useEffect } from 'react';
import { getTemplate } from '../service';

const { Option } = Select;

const TempleatModal = props => {
  const {
    visible,
    form: { getFieldDecorator, validateFields, resetFields },
    selectedRowKeys,
    templateList,
    isALL,
  } = props;
  const formItemLayout = {
    labelCol: {
      span: 5,
    },
    wrapperCol: {
      span: 16,
    },
  };
  const handleOk = async () => {
    console.log(props);
    validateFields(async (error, fieldsValue) => {
      if (!error) {
        const data = await getTemplate({
          isAll: isALL,
          skuIdList: selectedRowKeys,
          templateId: fieldsValue.templateId.key,
        });
        if (data.businessCode === '0000') {
          notification.success({ message: '配置成功！' });
          resetFields();
          props.onCancel();
        }
      }
    });
  };

  useEffect(() => {}, []);
  return (
    <Modal
      title={isALL ? '全部设置不支持配送区域' : '批量设置不支持配送区域'}
      visible={visible}
      width="500px"
      onCancel={props.onCancel}
      onOk={() => handleOk()}
    >
      {!isALL && <p>已选择{selectedRowKeys.length}个商品</p>}
      <Form {...formItemLayout}>
        <Form.Item label="选择模板">
          {getFieldDecorator('templateId', {
            rules: [{ required: true, message: '请选择模板!' }],
          })(
            <Select placeholder="请选择模板" labelInValue allowClear>
              {templateList.map(item => (
                <Option label={item.templateName} value={item.id} key={item.id}>
                  {item.templateName}
                </Option>
              ))}
            </Select>,
          )}
        </Form.Item>
      </Form>
    </Modal>
  );
};

export default Form.create()(TempleatModal);
