import React from 'react';
import { Button, Popconfirm, Badge } from 'antd';
import styles from './style.less';

export const productType = [
  {
    value: 1,
    title: '自营',
  },
  {
    value: 2,
    title: '京东开普勒',
  },
  {
    value: 3,
    title: '京东联盟',
  },
  {
    value: 4,
    title: '众联',
  },
  {
    value: 5,
    title: '企业购',
  },
  {
    value: 6,
    title: '企业购直连',
  },
];

export function column() {
  return [
    {
      title: 'SKU编码',
      dataIndex: 'skuId',
      width: 125,
      align: 'center',
      render: (_, row) => {
        if (row.type !== 1) {
          return (
            <Badge
              count={
                <div
                  style={{
                    color: '#fff',
                    borderRadius: '3px',
                    background: '#f5222d',
                    padding: '2px',
                    fontSize: '10px',
                    opacity: 0.7,
                  }}
                >
                  虚拟
                </div>
              }
            >
              <div
                style={{
                  background: '#fbfbfb',
                  borderRadius: '3px',
                  padding: '2px',
                }}
              >
                {row.skuId}
              </div>
            </Badge>
          );
        }
        return (
          <div
            style={{
              background: '#fbfbfb',
              borderRadius: '3px',
              padding: '2px',
            }}
          >
            {row.skuId}
          </div>
        );
      },
    },
    {
      title: 'SKU商品名称',
      width: 135,
      align: 'center',
      dataIndex: 'skuName',
    },
    {
      title: '价格',
      dataIndex: 'marketPrice',
      width: 150,
      align: 'center',
      sorter: (a, b) => a.supplyPrice - b.supplyPrice,
      render: (_, row) => (
        <div className={styles.price} onClick={() => this.openModal(row)}>
          <p>
            供货价：<a>{row.supplyPrice.toFixed(2)}</a>
          </p>
          <p>
            市场价：<a>{(row.marketPrice || 0).toFixed(2)}</a>
          </p>
        </div>
      ),
    },
    {
      title: '库存',
      width: 120,
      dataIndex: 'stock',
      align: 'center',
      sorter: (a, b) => a.stock - b.stock,
      render: (_, row) => (
        <>
          <p>
            当前库存：<a onClick={() => this.openModal(row, 'productStock')}>{row.productStock}</a>
          </p>
          <p>可售库存：{_}</p>
          {row.type === 1 && row.productStockWarning > -1 && (
            <p>预警值：{row.productStockWarning}</p>
          )}
        </>
      ),
    },
    {
      title: '商品状态',
      dataIndex: 'stateDesc',
      width: 200,
      align: 'center',
    },
    {
      title: '操作',
      dataIndex: 'action',
      width: 120,
      align: 'center',
      render: (_, row) => (
        <div className={styles.actionBtn}>
          {row.state !== 6 && (
            <Popconfirm
              key="up"
              placement="topLeft"
              title="确定要上架吗？"
              onConfirm={() => this.updateStatus(row.skuId, 6, '')}
              okText="确定"
              cancelText="取消"
            >
              <Button key="up" size="small" type="primary" className={styles.button}>
                上架
              </Button>
            </Popconfirm>
          )}
          {row.state === 6 && (
            <Button
              key="down"
              size="small"
              type="primary"
              className={styles.button}
              disabled={row.state !== 6}
              onClick={() => this.offLine(row.skuId, 7)}
            >
              下架
            </Button>
          )}
          <Button
            key="edit"
            type="primary"
            size="small"
            className={styles.button}
            onClick={() => this.onUpdateInfo(row)}
          >
            编辑
          </Button>
          <Button
            key="detail"
            size="small"
            type="primary"
            className={styles.button}
            onClick={() => this.showSupply(row.spuId, row.type)}
          >
            供货详情
          </Button>
          <Button
            key="viewP"
            type="primary"
            size="small"
            className={styles.button}
            onClick={() => this.audit(row.skuId)}
          >
            预览
          </Button>
          <Button
            key="log"
            size="small"
            type="primary"
            className={styles.button}
            onClick={() => this.viewLog(row.skuId)}
          >
            查看日志
          </Button>
        </div>
      ),
    },
  ];
}
export const disSelectStatus = [2, 5];
export const stateList = [
  { value: 5, label: '未上架' },
  { value: 6, label: '已上架' },
  { value: 7, label: '已下架' },
];
export const productTypeList = [
  { value: 1, label: '实体商品' },
  { value: 2, label: '虚拟充值' },
  { value: 3, label: '虚拟卡券', disabled: true },
];

export const JDSHOPID = [3, 5, 6];
