// import fileSaver from 'file-saver';
import request from '@/utils/request';
import config from '../../../config/env.config';
import { stringify } from 'qs';
import _ from 'lodash';

const { kdspApi } = config;
// const kdspApi = 'http://yapi.quantgroups.com/mock/389';
// 分页查询所有数据
const headers = {
  'Content-Type': 'application/x-www-form-urlencoded',
};

export const query = async params => {
  const tempParams = {
    ...params,
    startDate: params.dateRange?.[0],
    endDate: params.dateRange?.[1],
    pageNo: params.current,
  };
  delete tempParams.dateRange;
  delete tempParams.current;

  try {
    const {
      data: { current, records, total, size },
    } = await request.post('/product/page', {
      prefix: config.kdspApi,
      data: stringify(_.omitBy(tempParams, v => !v)),
      headers,
    });
    return {
      current,
      data: records,
      total,
      pageSize: size,
    };
  } catch (error) {
    return {};
  }
};

// export async function searchList(params) {
//   return request.post('/product/page', {
//     prefix: kdspApi,
//     data: stringify(_.omitBy(params, v => !v)),
//     headers,
//   });
// }

// 新增商品
export async function addGoods(params) {
  return request.post('/product/add', {
    prefix: kdspApi,
    params,
  });
}

// 编辑商品

export async function editGoods(params) {
  return request.post('/product/edit', {
    prefix: kdspApi,
    params,
  });
}

// 供应商列表
export async function getSupplierList() {
  return request.post('/channel/supplier/list', {
    prefix: kdspApi,
  });
}
// 获取商品品牌
export async function getBrandList() {
  return request.post('/product/brand/list', {
    prefix: kdspApi,
  });
}

// 编辑--获取详情
export async function spuDetail(params) {
  return request.post('/product/detail', {
    prefix: kdspApi,
    params,
    headers,
  });
}

// 商品规格
export async function getSpecList() {
  return request.post('/product/spec/list', {
    prefix: kdspApi,
  });
}

// 查询图片素材
export async function getImageInfo(spuNo) {
  return request.post('/product/imageInfo', {
    params: { spuNo },
    prefix: kdspApi,
    headers,
  });
}

// 状态
export async function statusList() {
  return request.post('/api/kdsp/op/mch_sku/status_list');
}
// 商品来源
export async function skuSource() {
  return request.post('/api/kdsp/sku/sku-info/getSkuSource');
}
// 商品分类
export async function categoryList() {
  return request.post('/product/category/getAll', {
    prefix: kdspApi,
    headers,
  });
}

// 批量修改
export async function uploadFile(file) {
  const params = new FormData();
  params.append('file', file);
  const data = await request.post('/product/item/batchUpdate', params, {
    rawData: true,
  });
  return data;
}

// 批量倒入京东skus
export async function importJdSkus(file, sourceType) {
  const params = new FormData();
  params.append('file', file);
  params.append('sourceType', sourceType);
  const data = await request.post('/product/importJdSkus', params, {
    rawData: true,
  });
  return data;
}

// 批量上架
export async function pushed(data) {
  return request.post('/api/kdsp/op/mch_sku/pushed', data);
}

// 批量下架
export async function offline(data) {
  return request.post('/api/kdsp/op/mch_sku/offline', data);
}

// 最新批量上下架
export async function batchPushedOrOffline(data) {
  return request.post('/product/pushedOrOffline/batch', data, {
    emulateJSON: true,
  });
}

// 商品修改
export async function update(params) {
  return request.post('/api/kdsp/op/mch_sku/update', params, {
    emulateJSON: true,
  });
}

// 商品修改日志
export async function changeLog(params) {
  return request.post('/product/logs/page', params, {
    emulateJSON: true,
  });
}

// 商品详情
export async function detail(params) {
  return request.post('/product/supply/list', params, {
    emulateJSON: true,
  });
}

// 拉去京东图片
export async function getJdPicList(params) {
  const [data] = await request.post('/product/item/getJdPicList', params, {
    emulateJSON: true,
  });
  return data;
}

// 添加商品
export async function addSku(params) {
  const [, error] = await request.post('/api/kdsp/op/mch_sku/add_sku', params);
  return error;
}

// 修改商品
export async function updateSku(params) {
  const [, error] = await request.post('/api/kdsp/op/mch_sku/update', params);
  return error;
}

// 图片上传
export async function uploadImg(files) {
  const params = new FormData();
  files.map(file => params.append('file', file));
  const data = await request.post('/image/upload', params, {
    rawData: true,
  });
  return data;
}
// 修改商品价格
export async function updatePrice(params) {
  const [, error] = await request.post('/product/item/updatePrice', params, {
    emulateJSON: true,
  });
  return error;
}
// 修改商品库存
export async function updateStock(params) {
  const [, error] = await request.post('/product/item/updateStock', params, {
    emulateJSON: true,
  });
  return error;
}

// 获取虚拟商品类目
export async function getVirtualCategory() {
  const data = await request.post('/product/category/getByParentId', {
    prefix: kdspApi,
    params: { id: 100018 },
    headers,
  });
  return data;
}
