import React, { useEffect } from 'react';
import SuperSelect from 'antd-virtual-select';
import {
  Form,
  Modal,
  Card,
  Cascader,
  Select,
  Radio,
  Popover,
  Input,
  Icon,
  Button,
  Row,
  Col,
  notification,
} from 'antd';
import { productTypeList } from '../staticdata';
import { useModalTitle, useSpecList, formItemLayout, filterSpecId } from './utils';
import { RadioComponent, CascaderComponent } from './libs';
import { productTypeRules, categoryIdRules, brandIdRules } from './rules';
import { SelectSpecifications } from './SelectSpecifications';

const { Option } = Select;

const filterOption = (input, op) => op.props.children.includes(input);

const OperationForm = props => {
  const {
    isEdit,
    operationVisible,
    setOperationVisible,
    categoryData,
    // virtualTreeData,
    shopList,
    barndList,
    // virtualBarndList,
    form,
  } = props;
  const {
    getFieldDecorator,
    setFieldsValue,
    getFieldsValue,
    validateFields,
    resetFields,
    getFieldValue,
  } = form;
  const [title] = useModalTitle(isEdit);

  const [specList] = useSpecList();

  useEffect(() => {
    console.log(isEdit);
    if (isEdit) {
      setFieldsValue({
        productType: 2,
      });
    } else {
      setFieldsValue({
        productType: 1,
      });
    }
  }, [isEdit, operationVisible]);

  const onSubmitGoodsForm = () => {
    validateFields(async (errors, values) => {
      if (!errors) {
        const { first = [], firstKeys = [] } = values;
        console.log(values);
        console.log(firstKeys.map(key => first[key]));
      }
    });
  };
  const onCancelModalForm = () => {
    setOperationVisible(false);
    resetFields();
  };

  const { name } = getFieldsValue();

  return (
    <Modal
      title={title}
      width="1050px"
      visible={operationVisible}
      onCancel={onCancelModalForm}
      onOk={() => onSubmitGoodsForm()}
    >
      <Form {...formItemLayout}>
        <Card>
          <Form.Item label="商品类型：">
            {getFieldDecorator('productType', productTypeRules())(
              RadioComponent({ productTypeList }),
            )}
          </Form.Item>
          <Form.Item label="类目：">
            {getFieldDecorator('categoryId', categoryIdRules())(
              CascaderComponent({ categoryData }),
            )}
          </Form.Item>
          <Form.Item label="商品品牌">
            {getFieldDecorator('brandId', brandIdRules())(
              <SuperSelect allowClear showSearch filterOption={filterOption}>
                {barndList.map(item => (
                  <Option key={item.id} value={item.id}>
                    {item.name}
                  </Option>
                ))}
              </SuperSelect>,
            )}
          </Form.Item>
          <Form.Item label="商品名称">
            <Popover content={name} trigger="hover">
              {getFieldDecorator('name', {
                rules: [{ required: true, message: '请输入商品名称' }],
              })(<Input allowClear />)}
            </Popover>
          </Form.Item>
        </Card>
        <Card>
          <SelectSpecifications
            form={form}
            keys="firstKeys"
            arrkey="first"
            formKey="firstSpecId"
            labelName="一级规格"
            specList={specList}
          />
          <SelectSpecifications
            form={form}
            keys="secondKeys"
            arrkey="tow"
            formKey="secondSpecId"
            labelName="二级规格"
            specList={specList}
          />
        </Card>
      </Form>
    </Modal>
  );
};
export default Form.create()(OperationForm);
