import React, { useEffect, useState } from 'react';
import { getSpecList } from '../service';

export const formItemLayout = {
  labelCol: {
    xs: { span: 24 },
    sm: { span: 2 },
  },
  wrapperCol: {
    xs: { span: 24 },
    sm: { span: 22 },
  },
};

export const useModalTitle = isEdit => {
  const titleText = isEdit ? '修改商品' : '新增商品';
  return [titleText];
};

export const useSpecList = () => {
  const [specList, setSpecList] = useState([]);
  useEffect(() => {
    const featchData = async () => {
      const { data = [] } = await getSpecList();
      setSpecList(data);
    };
    featchData();
  }, []);
  return [specList];
};

export const filterSpecId = (input, option) =>
  option.props.children.toLowerCase().indexOf(input.toLowerCase()) >= 0;
