import { Card, Form, Pagination, Table, notification, Drawer, Spin } from 'antd';
import React, { Component } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import { connect } from 'dva';
import { sortBy } from 'lodash';
import styles from './style.less';
import LocalStroage from '@/utils/localStorage';
import configApi from '../../../config/env.config';
import UpdatePrice from './UpdatePrice';
import UpdateStock from './UpdateStock';

import {
  update,
  spuDetail,
  detail,
  getSupplierList,
  batchPushedOrOffline,
  categoryList,
  getVirtualCategory,
} from './service';
import LogModal from './LogModal';
import CreateModal from './createModal';
import SupplyModal from './SupplyModal';
import ReasonModal from './reasonModal';
import { column, JDSHOPID } from './staticdata';
import SearchForm from './SearchForm';

@connect(({ goodsManage }) => ({
  goodsManage,
}))
class goodsManage extends Component {
  state = {
    pageNo: 1,
    treeData: [],
    virtualTreeData: [],
    pageSize: 20,
    priceInfo: {},
    logVisible: false,
    previewVisible: false,
    supplyVisible: false,
    createVisible: false, // 新增or编辑普通商品modal
    offlineVisible: false,
    selectedParams: {},
    detailData: [],
    detailSpuId: '',
    selectedRowKeys: [],
    updatePriceVisible: false,
    updateStockVisible: false,
    initData: {},
    createloading: false,
    type: 1,
  };

  loading = false;

  currentSkuId = null;

  supplierId = null;

  shopList = [];

  componentDidMount() {
    this.props.goodsManage.tableData = {};
    this.getShopList();
    this.categoryList();
    this.getVirtualCategory();
  }

  openOffline = (ids, type, productState) => {
    const obj = { ids, type, productState };
    this.setState({ selectedParams: obj });
    this.setState({ offlineVisible: true });
  };

  showSupply = async (id, type) => {
    const { data } = await detail({ id });
    this.setState({ supplyVisible: true, detailData: data, type });
  };

  handleSearch = page => {
    this.loading = true;
    const currentPage = this.state.pageNo;
    this.setState(
      {
        pageNo: page || currentPage,
      },
      () => {
        const { dispatch } = this.props;
        const { pageSize, pageNo } = this.state;
        dispatch({
          type: 'goodsManage/getList',
          payload: {
            pageNo,
            pageSize,
            ...this.searchForm.getFieldsValue(),
          },
        });
        this.loading = false;
      },
    );
  };

  onPageChange = page => {
    this.handleSearch(page);
  };

  onPageSizeChange = (current, size) => {
    this.setState(
      {
        pageSize: size,
      },
      () => this.handleSearch(),
    );
  };

  onSelectChange = selectedRowKeys => {
    this.setState({ selectedRowKeys });
  };

  onReset = () => {
    this.setState({
      pageNo: 1,
      pageSize: 20,
      selectedRowKeys: [],
    });
    this.handleSearch();
  };

  onUpdateInfo = async ({ spuId, productType }) => {
    this.setState({
      createloading: true,
    });
    const { data } = await spuDetail({ id: spuId });
    if (data) {
      data.pageProductType = productType;
      data.categoryId = data.thirdCategoryId;
      data.firstSpecId = data.skuList[0].firstSpecId;
      data.secondSpecId = data.skuList[0].secondSpecId;
      data.firstSpecName = data.skuList[0].firstSpec;
      data.secondSpecName = data.skuList[0].secondSpec;
      data.firstSpecList = [];
      data.secondSpecList = [];
      data.colorKeys = [];
      data.carouseList.forEach(i => {
        if (i.specValue) {
          data.colorKeys.push(i.specValue);
        }
      });
      data.skuList.forEach(i => {
        if (data.firstSpecList.indexOf(i.firstSpecValue) === -1) {
          data.firstSpecList.push(`${i.firstSpecValue}`);
        }
        if (i.secondSpecValue && data.secondSpecList.indexOf(i.secondSpecValue) === -1) {
          data.secondSpecList.push(i.secondSpecValue);
        }
      });

      data.imageList = [];
      data.carouseList.forEach(i => {
        data.imageList[`${i.specValue}`] = i.skuSpecImageList || [];
      });
      data.editData = sortBy(data.skuList, item => item.firstSpecValue);
      this.setState({
        initData: data,
        createVisible: true,
        createloading: false,
      });
    }
  };

  onUpdate = async updateData => {
    const [, error] = await update(updateData);
    this.onLoad(error);
  };

  onLoad = error => {
    if (!error) {
      notification.success({ message: '操作成功' });
      this.setState({
        selectedRowKeys: [],
      });
      this.handleSearch();
    }
  };

  viewLog = async skuId => {
    this.currentSkuId = skuId;
    this.setState({
      logVisible: true,
    });
  };

  updateStatus = async (ids, productState, offlineReason, fromDetail) => {
    const data = await batchPushedOrOffline({
      ids,
      productState,
      offlineReason,
    });
    if (data.businessCode === '0000') {
      this.handleSearch();
      notification.success({
        message: productState === 6 ? '上架成功' : '下架成功',
      });
      this.setState({ offlineVisible: false });
      if (fromDetail) {
        this.showDetail(this.state.detailSpuId);
      }
    }
  };

  audit = skuId => {
    this.setState({
      previewVisible: true,
      src: `${configApi.prologueDomain}/goods/${skuId}?h=0&token=${LocalStroage.get(
        'token',
      )}&hideReport=1&time=${Date.now()}`,
    });
  };

  offLine = (ids, productState) => {
    const obj = { ids, productState };
    this.setState({ offlineVisible: true, selectedParams: obj });
  };

  // 获取供应商列表
  getShopList = async () => {
    const { data } = await getSupplierList();
    this.shopList = data || [];
  };

  filterShopList = (list = [], isEdit) =>
    list.filter(item => isEdit || !JDSHOPID.includes(item.id));

  openModal = (
    {
      skuId,
      supplyPrice,
      marketPrice,
      salePrice,
      marketableStock,
      supplierId,
      stock,
      productStock,
    },
    isStock,
  ) => {
    let visible = {};
    if (isStock) {
      visible = { updateStockVisible: true };
    } else {
      visible = { updatePriceVisible: true };
    }
    this.setState({
      ...visible,
      priceInfo: {
        id: skuId,
        stock,
        productStock,
        marketableStock,
        supplyPrice,
        marketPrice,
        salePrice,
        supplierId,
      },
    });
  };

  cancel = query => {
    this.setState({ updatePriceVisible: false, updateStockVisible: false });
    if (query) {
      this.handleSearch();
    }
  };

  categoryList = async () => {
    const { data: treeData } = await categoryList();
    if (!treeData) return;
    this.setState({ treeData });
  };

  getVirtualCategory = async () => {
    const { data: virtualTreeData } = await getVirtualCategory();
    if (!virtualTreeData) return;
    this.setState({ virtualTreeData });
  };

  render() {
    const {
      goodsManage: { tableData = {} },
    } = this.props;
    const { pageNo, pageSize, selectedRowKeys } = this.state;
    const rowSelection = {
      selectedRowKeys,
      onChange: this.onSelectChange,
      getCheckboxProps: record => ({
        disabled: +record.state === 6, // Column configuration not to be checked
      }),
    };
    return (
      <PageHeaderWrapper>
        <Spin spinning={this.state.createloading}>
          <Card>
            <SearchForm
              handleSearch={this.handleSearch}
              onReset={this.onReset}
              onLoad={this.onLoad}
              selectedRowKeys={this.state.selectedRowKeys}
              onRef={ref => {
                this.searchForm = ref;
              }}
              treeData={this.state.treeData}
              shopList={this.shopList}
              addSpu={() => this.setState({ createVisible: true, initData: {} })}
            />
          </Card>
          <Spin spinning={this.loading}>
            <Table
              dataSource={tableData?.records}
              bordered
              columns={column.call(this)}
              rowKey={record => record.skuId}
              pagination={false}
              className={styles.tabletop}
              rowSelection={rowSelection}
              scroll={{ x: '100%', y: 500 }}
            />
          </Spin>
          <br />
          {tableData && (
            <Pagination
              onChange={this.onPageChange}
              total={tableData.total}
              showTotal={total => `共${total}条`}
              current={pageNo}
              pageSize={pageSize}
              showSizeChanger
              onShowSizeChange={this.onPageSizeChange}
            />
          )}

          <LogModal
            visible={this.state.logVisible}
            id={this.currentSkuId}
            onCancel={() => {
              this.currentSkuId = null;
              this.setState({ logVisible: false });
            }}
          />
          <Drawer
            visible={this.state.previewVisible}
            width="450"
            onClose={() => {
              this.setState({ previewVisible: false });
            }}
            title="商品预览"
          >
            <iframe
              src={this.state.src}
              frameBorder="0"
              height="600"
              width="375"
              title="商品预览"
            ></iframe>
          </Drawer>
          <CreateModal
            initData={this.state.initData}
            visible={this.state.createVisible}
            onCancel={() => {
              this.setState({ createVisible: false, initData: {} });
            }}
            query={() => this.handleSearch()}
            shopList={this.filterShopList(this.shopList, Object.keys(this.state.initData).length)}
            treeData={this.state.treeData}
            virtualTreeData={this.state.virtualTreeData}
          ></CreateModal>
          <SupplyModal
            data={this.state.detailData}
            visible={this.state.supplyVisible}
            type={this.state.type}
            onCancel={() => {
              this.setState({ supplyVisible: false });
            }}
          ></SupplyModal>

          <ReasonModal
            visible={this.state.offlineVisible}
            submit={reason => {
              const { ids, productState } = this.state.selectedParams;
              this.updateStatus(ids, productState, reason);
            }}
            onCancel={() => {
              this.setState({ offlineVisible: false });
            }}
          ></ReasonModal>
          <UpdatePrice
            visible={this.state.updatePriceVisible}
            info={this.state.priceInfo}
            onCancel={this.cancel}
          />
          <UpdateStock
            visible={this.state.updateStockVisible}
            info={this.state.priceInfo}
            onCancel={this.cancel}
          />
        </Spin>
      </PageHeaderWrapper>
    );
  }
}

export default Form.create()(goodsManage);
