import React, { useEffect, useState, useRef } from 'react';
import { PageHeaderWrapper } from '@ant-design/pro-layout';
import ProTable from '@ant-design/pro-table';
import { Button } from 'antd';
import { categoryList, query, getVirtualCategory, getSupplierList, getBrandList } from './service';
import { Goodscolumns } from './Goodscolumns';
import styled from './style.less';
// eslint-disable-next-line import/extensions
import OperationModal from './OperationModal/index.jsx';

export default () => {
  /**
   * @name screenLoading
   * @type boolean
   * @desc 整个页面的加载状态
   */
  const [isEdit, setIsEdit] = useState(false);
  const [categoryData, setCategoryData] = useState([]);
  const [operationVisible, setOperationVisible] = useState(false);
  const actionRef = useRef();
  const supplyPriceRef = useRef();
  const [supplyPrice, setSupplyPrice] = useState([]);
  const [virtualTreeData, setVirtualTreeData] = useState([]);
  const [shopList, setShopList] = useState([]);
  const [barndList, setBarndList] = useState([]);
  const [virtualBarndList, setVirtualBarndList] = useState([]);

  useEffect(() => {
    const featchData = async () => {
      const { data = [] } = await categoryList();
      const { data: virtualData = [] } = await getVirtualCategory();
      const { data: shopData = [] } = await getSupplierList();
      const { data: barndData = [] } = await getBrandList();
      const virtualBarndData = barndData.filter(item => item.name === '虚拟商品');
      setCategoryData(data);
      setVirtualTreeData(virtualData);
      setShopList(shopData);
      setBarndList(barndData);
      setVirtualBarndList(virtualBarndData);
    };
    featchData();
  }, []);

  const onAddGoodsForm = () => {
    setIsEdit(false);
    setOperationVisible(true);
  };

  const onModifyForm = () => {
    // 修改form表单事件
    setIsEdit(true);
    setOperationVisible(true);
  };
  const toolBarList = [
    <Button key="getOffGoodsShelf" type="primary" onClick={() => onAddGoodsForm()}>
      新增商品
    </Button>,
    <Button key="putGoodsShelf">模版</Button>,
    <Button key="tags" type="primary">
      批量修改库存
    </Button>,
  ];

  return (
    <PageHeaderWrapper>
      <ProTable
        className={styled.protable}
        actionRef={actionRef}
        columns={Goodscolumns({
          categoryData,
          supplyPrice,
          setSupplyPrice,
          supplyPriceRef,
          onModifyForm,
        })}
        params={{ ...supplyPrice }}
        request={params => {
          // 表单搜索项会从 params 传入，传递给后端接口。
          const [supplyPriceMin, supplyPriceMax] = supplyPrice;
          return query({ supplyPriceMin, supplyPriceMax, ...params });
        }}
        rowKey="skuId"
        bordered
        scroll={{ x: 1500 }}
        search={{
          collapsed: false,
        }}
        toolBarRender={() => toolBarList}
        pagination={{
          showQuickJumper: true,
          defaultPageSize: 10,
          size: 'default',
          showTitle: false,
          showTotal: () => null,
        }}
        onReset={() => {
          setSupplyPrice([]);
        }}
        options={{
          density: false,
          fullScreen: false,
          setting: false,
          reload: false,
        }}
      />
      <OperationModal
        isEdit={isEdit}
        operationVisible={operationVisible}
        setOperationVisible={setOperationVisible}
        categoryData={categoryData} // 实体商品类目
        virtualTreeData={virtualTreeData} // 虚拟商品类目
        shopList={shopList} // 供货商数据
        barndList={barndList}
        virtualBarndList={virtualBarndList}
      />
      {/* rowSelection={rowSelection} */}
      {/* <div>helloworld</div> */}
    </PageHeaderWrapper>
  );
};
