import React from 'react';

import { Radio, Cascader } from 'antd';

export const RadioComponent = ({ productTypeList }) => (
  <Radio.Group>
    {productTypeList.map(item => (
      <Radio key={item.value} value={item.value} disabled={item.disabled}>
        {item.label}
      </Radio>
    ))}
  </Radio.Group>
);

export const CascaderComponent = ({ categoryData }) => (
  <Cascader
    changeOnSelect
    showSearch
    fieldNames={{ label: 'name', value: 'id', children: 'children' }}
    options={categoryData}
  />
);
