import debounce from 'lodash/debounce';
import { apiEnterpriseList, apiShopList, apiShopListByPickSelfID } from './index';

// 获取企业列表
export const getEnterpriseList = async () => {
  const res = await apiEnterpriseList({
    page: 1,
    size: 10000,
  });
  if (res && res.data && res.data.records) {
    const data = res.data.records;
    const json = {};
    data.forEach(item => {
      json[item.id] = { text: item.name };
    });
    return {
      id: data[data.length - 1].id,
      list: json,
    };
  }
  return {
    id: '',
    list: {},
  };
};
// 获取店铺列表
export const getShopList = debounce(async e => {
  const { name } = e;
  const res = await apiShopList({ name });
  if (res && res.data && res.data.records) {
    const data = res.data.records;
    const json = {};
    data.forEach(item => {
      json[item.id] = { text: item.name };
    });
    return {
      id: res[res.length - 1].id,
      list: json,
    };
  }
  return {
    id: '',
    list: {},
  };
}, 300);
// 获取店铺列表通过自提点ID
export const getShopListByPickSelf = async e => {
  const { name } = e;
  const res = await apiShopListByPickSelfID({ name });
  if (res && res.data && res.data.records) {
    const data = res.data.records;
    const json = {};
    data.forEach(item => {
      json[item.id] = { text: item.name };
    });
    return {
      id: res[res.length - 1].id,
      list: json,
    };
  }
  return {
    id: '',
    list: {},
  };
};
