import request from '@/utils/request';
// 待发货订单
export async function queryToSend(params) {
  const statusMap = {
  	'全部': 3,
  	'未发货': 1,
  	'已发货': 2,
  }
  const transformedParam = {
  	...params,
  	logisticsStatus: statusMap[params.logisticsStatus] || 3,
  	pageNo: params.current,
    pageSize: params.pageSize || 20,
  }
  const { data: { currentPage, dataList, totalCount } } = await request.post('/api/kdsp/op/mch-order/list', {
    data: transformedParam
  });
  return {
    current: currentPage,
    data: dataList,
    total: totalCount
  }
}

// 快递公司
export async function queryExpress() {
	 const { data } = await request.get('/api/kdsp/op/express/list');
   return data;
}

export async function updateExpress(params) {
  return request.post('/api/kdsp/op/order/update-express-info', {
    data: params
  });
}