import React from 'react';
import { Button } from 'antd';

export const dateStateEnum = {
  1: { text: '一周', maxlength: 8 },
  2: { text: '半个月', maxlength: 4 },
  3: { text: ' 一个月', maxlength: 2 },
};

export const orderStateNum = {
  1: { text: '待结算' },
  2: { text: '已结算' },
  3: { text: '无需结算' },
};

export const paymentStateEnum = {
  true: { text: '是' },
  false: { text: '否' },
};

export function columns(pages) {
  const { current, pageSize } = pages;
  return [
    {
      title: '序号',
      dataIndex: 'index',
      hideInSearch: true,
      width: '50px',
      align: 'center',
      render: (text, record, index) => (current - 1) * pageSize + index + 1,
    },
    {
      title: '供应商名称',
      dataIndex: 'supplierName',
      width: '150px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '付款单批次号',
      dataIndex: 'payBatchNo',
      width: '160px',
      align: 'center',
    },
    {
      title: '结算单批次号',
      dataIndex: 'settleBatchNo',
      width: '150px',
      align: 'center',
    },
    {
      title: '结算单生成日期',
      key: 'dateTimeRange',
      dataIndex: 'createdAtRange',
      valueType: 'dateRange',
      width: '120px',
      hideInTable: true,
      initialValue: [],
      align: 'center',
    },
    {
      title: '帐单确认周期',
      dataIndex: 'createdAtRange',
      key: 'createdAtRange',
      hideInSearch: true,
      align: 'center',
      width: '160px',
      render: (text, record) => `${record.billPeriodStart}-${record.billPeriodEnd}`,
    },
    {
      title: '账期',
      dataIndex: 'billPeriodType',
      valueEnum: dateStateEnum,
      width: '120px',
      hideInSearch: true,
      filters: false,
      align: 'center',
    },
    {
      title: '结算单生成日期',
      dataIndex: 'createdAt',
      key: 'createdAt',
      hideInSearch: true,
      align: 'center',
      width: '160px',
    },
    {
      title: '销售金额',
      dataIndex: 'saleAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '退款金额',
      dataIndex: 'refundAmount',
      width: '100px',
      hideInSearch: true,
      align: 'center',
      render: (value, row) => (
        <div>
          <div>{value}</div>
          <div style={{ color: '#f00' }}>(赔付{row.claimAmount})</div>
        </div>
      ),
    },
    {
      title: '结算金额',
      dataIndex: 'payableAmount',
      width: '130px',
      hideInSearch: true,
      align: 'center',
    },
    {
      title: '结算状态',
      dataIndex: 'settleState',
      valueEnum: orderStateNum,
      width: '100px',
      initialValue: 0,
      filters: false,
      align: 'center',
    },
    {
      title: '是否生成付款单',
      dataIndex: 'isCreatePaymentBill',
      valueEnum: paymentStateEnum,
      hideInTable: true,
      align: 'center',
    },
  ];
}

export const toolBarRender = ({ paymentOrder, canEditable }) => () => [
  canEditable ? (
    <Button type="primary" onClick={paymentOrder}>
      生成付款单
    </Button>
  ) : (
    <></>
  ),
];
