import { Row, Col, Button } from 'antd';
import React, { Component } from 'react';
import styles from '../style.less';

// eslint-disable-next-line react/prefer-stateless-function
class ButtonGroup extends Component {
  render() {
    const { initData, confirmLoading } = this.props;
    return (
      <Row type="flex" justify="center" align="middle" gutter={20}>
        <Col>
          <Button type="primary" onClick={() => this.props.onCancel()} className={styles.logBtn}>
            取消
          </Button>
        </Col>
        <Col key="submit">
          <Button
            type="primary"
            onClick={() => this.props.confirm()}
            className={styles.logBtn}
            loading={confirmLoading}
            disabled={confirmLoading}
          >
            提交
          </Button>
        </Col>
        {initData && !Object.keys(initData).length && (
          <Col key="submit-add">
            <Button
              type="primary"
              onClick={() => this.props.confirm(true)}
              className={styles.logBtn}
              loading={confirmLoading}
              disabled={confirmLoading}
            >
              提交并继续添加
            </Button>
          </Col>
        )}
      </Row>
    );
  }
}

export default ButtonGroup;
