import qs from 'qs';
import request from '@/utils/request';
import config from '@/../config/env.config';

const { kdspApi } = config;

/**
 * 分页查询所有品牌列表
 * /yapi/project/389/interface/api/66404
 */
export async function apiBrandList(params) {
  const param = {
    ...params,
    pageNo: params.current,
  };
  const res = await request.get(`/api/merchants/brands/list?${qs.stringify(param)}`, {
    prefix: kdspApi,
  });
  if (res?.data) {
    return {
      total: res.data.total,
      data: res.data.records,
    };
  }
  return {
    total: 0,
    data: [],
  };
}

/**
 * 添加品牌
 * /yapi/project/389/interface/api/66389
 * */
export async function apiCreateBrand(data) {
  return request.post('/api/merchants/brands/add', {
    data,
    prefix: kdspApi,
  });
}

/**
 * 编辑品牌
 * /yapi/project/389/interface/api/66394
 */
export async function apiEditBrand(data) {
  return request.post('/api/merchants/brands/edit', {
    data,
    prefix: kdspApi,
  });
}

/**
 * 补充资质
 * /yapi/project/389/interface/api/66399
 */
export async function apiAppendQualifyBrand(data) {
  return request.post('/api/merchants/brands/qualify/add', {
    data,
    prefix: kdspApi,
  });
}

/**
 * 查询品牌信息
 * /yapi/project/389/interface/api/66409
 * */
export async function apiBrandDetail(params) {
  return request.get(`/api/merchants/brands/detail?${qs.stringify(params)}`, {
    prefix: kdspApi,
  });
}
