import React, { useState } from 'react';
import { Form, notification, Col, Input, Icon, Row, Button, Select } from 'antd';
import { filterSpecId } from './utils';

export const SelectSpecifications = ({
  form,
  keys,
  formKey,
  labelName,
  specList,
  formValue,
  labelKey,
}) => {
  const { getFieldValue, getFieldDecorator, setFieldsValue } = form;
  const [countNumber, setCountNumber] = useState(0); // 添加计数器

  getFieldDecorator(keys, { initialValue: [] });
  const remove = k => {
    const valueKey = getFieldValue(keys);
    const removeItem = valueKey.filter(i => i !== k);
    setFieldsValue({
      [keys]: removeItem,
    });
    setCountNumber(removeItem.length);
  };

  const add = () => {
    const specValue = getFieldValue(formKey);
    if (!specValue) {
      notification.warning({ message: `请先选择${labelName}数据` });
      return;
    }
    const valueKey = getFieldValue(keys);
    const nextKeys = [...valueKey, countNumber];
    setCountNumber(countNumber + 1);
    setFieldsValue({
      [keys]: nextKeys,
    });
  };

  const onChange = option => {
    // setFieldsValue({
    //   [labelKey]: option.props.children,
    // });
  };

  const formItemList = getFieldValue(keys);
  const formItems = formItemList.map((k, index) => (
    <Col style={{ marginRight: 20 }} key={k}>
      <Form.Item style={{ width: 200 }} required={false}>
        {getFieldDecorator(`${formValue}[${index}]`, {
          validateTrigger: ['onChange', 'onBlur'],
          rules: [{ required: true, whitespace: true, message: 'Please input passenger' }],
        })(<Input placeholder="passenger name" style={{ width: 150, marginRight: 8 }} />)}
        <Icon className="dynamic-delete-button" type="minus-circle-o" onClick={() => remove(k)} />
      </Form.Item>
    </Col>
  ));

  return (
    <>
      <Form.Item label={labelName}>
        {getFieldDecorator(formKey)(
          <Select
            labelInValue
            allowClear
            showSearch
            onChange={(_, option) => onChange(option)}
            filterOption={filterSpecId}
          >
            {specList.map(item => (
              <Select.Option key={item.specId} value={item.specId}>
                {item.specName}
              </Select.Option>
            ))}
          </Select>,
        )}
      </Form.Item>
      <Row type="flex">
        {formItems}
        <Col>
          <Button type="dashed" style={{ marginTop: 5 }} onClick={() => add()}>
            <Icon type="plus" />
          </Button>
        </Col>
      </Row>
    </>
  );
};
